/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.templating;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.Output;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.JacksonMapper;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;

@Schema(title="Templatize task properties using Kestra\u2019s Pebble templating.", description="This task's `spec` property allows you to fully templatize all task properties using Kestra's Pebble templating. This way, all task properties and their values can be dynamically rendered based on your custom inputs, variables, and outputs from other tasks.")
@Plugin(examples={@Example(code={"spec: |\n  type: io.kestra.plugin.core.http.Download\n  {{ task.property }}: {{ task.value }}"})}, aliases={"io.kestra.core.tasks.templating.TemplatedTask"})
public class TemplatedTask
extends Task
implements RunnableTask<Output> {
    private static final ObjectMapper OBJECT_MAPPER = JacksonMapper.ofYaml();
    @NotNull
    @Schema(title="The templated task specification")
    private Property<String> spec;

    @Override
    public Output run(RunContext runContext) throws Exception {
        String taskSpec = runContext.render(this.spec).as(String.class).orElseThrow();
        try {
            Task task = (Task)OBJECT_MAPPER.readValue(taskSpec, Task.class);
            if (task instanceof TemplatedTask) {
                throw new IllegalArgumentException("The templated task cannot be of type 'io.kestra.plugin.core.templating.TemplatedTask'");
            }
            if (task instanceof RunnableTask) {
                RunnableTask runnableTask = (RunnableTask)((Object)task);
                return runnableTask.run(runContext);
            }
            throw new IllegalArgumentException("The templated task must be a runnable task");
        }
        catch (JsonProcessingException e) {
            throw new IllegalVariableEvaluationException(e);
        }
    }

    @Generated
    protected TemplatedTask(TemplatedTaskBuilder<?, ?> b) {
        super(b);
        this.spec = b.spec;
    }

    @Generated
    public static TemplatedTaskBuilder<?, ?> builder() {
        return new TemplatedTaskBuilderImpl();
    }

    @Generated
    public String toString() {
        return "TemplatedTask(super=" + super.toString() + ", spec=" + String.valueOf(this.getSpec()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TemplatedTask)) {
            return false;
        }
        TemplatedTask other = (TemplatedTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<String> this$spec = this.getSpec();
        Property<String> other$spec = other.getSpec();
        return !(this$spec == null ? other$spec != null : !((Object)this$spec).equals(other$spec));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TemplatedTask;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<String> $spec = this.getSpec();
        result = result * 59 + ($spec == null ? 43 : ((Object)$spec).hashCode());
        return result;
    }

    @Generated
    public Property<String> getSpec() {
        return this.spec;
    }

    @Generated
    public TemplatedTask() {
    }

    @Generated
    public static abstract class TemplatedTaskBuilder<C extends TemplatedTask, B extends TemplatedTaskBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Property<String> spec;

        @Generated
        public B spec(Property<String> spec) {
            this.spec = spec;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "TemplatedTask.TemplatedTaskBuilder(super=" + super.toString() + ", spec=" + String.valueOf(this.spec) + ")";
        }
    }

    @Generated
    private static final class TemplatedTaskBuilderImpl
    extends TemplatedTaskBuilder<TemplatedTask, TemplatedTaskBuilderImpl> {
        @Generated
        private TemplatedTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected TemplatedTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TemplatedTask build() {
            return new TemplatedTask(this);
        }
    }
}

