/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.trigger;

import com.cronutils.model.Cron;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import com.google.common.collect.ImmutableMap;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.Label;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.conditions.ScheduleCondition;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.Backfill;
import io.kestra.core.models.triggers.RecoverMissedSchedules;
import io.kestra.core.models.triggers.Schedulable;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.models.triggers.TriggerOutput;
import io.kestra.core.models.triggers.TriggerService;
import io.kestra.core.runners.DefaultRunContext;
import io.kestra.core.runners.RunContext;
import io.kestra.core.services.ConditionService;
import io.kestra.core.services.LabelService;
import io.kestra.core.utils.ListUtils;
import io.kestra.core.validations.ScheduleValidation;
import io.kestra.core.validations.TimezoneId;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Null;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Schema(title="Schedule a flow based on a CRON expression.", description="You can add multiple Schedule triggers to a flow.\nThe scheduler keeps track of the last scheduled date, allowing you to easily [backfill](https://kestra.io/docs/concepts/backfill) missed executions.\nKeep in mind that if you change the trigger ID, the scheduler will consider this as a new schedule, and will start creating new scheduled executions from the current date.\nBy default, all schedules use UTC. If you need a different timezone, add the `timezone` property to your trigger definition.")
@Plugin(examples={@Example(title="Schedule a flow every 15 minutes.", full=true, code={"id: scheduled_flow\nnamespace: company.team\n\ntasks:\n  - id: sleep_randomly\n    type: io.kestra.plugin.scripts.shell.Commands\n    taskRunner:\n      type: io.kestra.plugin.core.runner.Process\n    commands:\n      - echo \"{{ trigger.date ?? execution.startDate }}\"\n      - sleep $((RANDOM % 60 + 1))\n\ntriggers:\n  - id: every_15_minutes\n    type: io.kestra.plugin.core.trigger.Schedule\n    cron: \"*/15 * * * *\"\n"}), @Example(full=true, title="Schedule a flow every day at 6:30 AM", code={"    id: daily_flow\n    namespace: company.team\n\n    tasks:\n      - id: log\n        type: io.kestra.plugin.core.log.Log\n        message: It's {{ trigger.date ?? taskrun.startDate | date(\"HH:mm\") }}\n\n    triggers:\n      - id: schedule\n        type: io.kestra.plugin.core.trigger.Schedule\n        cron: 30 6 * * *\n"}), @Example(title="Schedule a flow every hour using the cron nickname `@hourly`.", code={"id: scheduled_flow\nnamespace: company.team\n\ntasks:\n  - id: log_hello_world\n    type: io.kestra.plugin.core.log.Log\n    message: Hello World! \ud83d\ude80\n\ntriggers:\n  - id: hourly\n    type: io.kestra.plugin.core.trigger.Schedule\n    cron: \"@hourly\"\n"}, full=true), @Example(title="Schedule a flow on the first Monday of the month at 11:00 AM.", code={"id: scheduled_flow\nnamespace: company.team\n\ntasks:\n  - id: log_hello_world\n    type: io.kestra.plugin.core.log.Log\n    message: Hello World! \ud83d\ude80\n\ntriggers:\n  - id: schedule\n    cron: \"0 11 * * 1\"\n    conditions:\n      - type: io.kestra.plugin.core.condition.DayWeekInMonth\n        date: \"{{ trigger.date }}\"\n        dayOfWeek: \"MONDAY\"\n        dayInMonth: \"FIRST\"\n"}, full=true), @Example(title="Schedule a flow every day at 9:00 AM and pause a schedule trigger after a failed execution using the `stopAfter` property.", full=true, code={"id: business_critical_flow\nnamespace: company.team\n\ntasks:\n  - id: important_task\n    type: io.kestra.plugin.core.log.Log\n    message: \"if this run fails, disable the schedule until the issue is fixed\"\n\ntriggers:\n  - id: stop_after_failed\n    type: io.kestra.plugin.core.trigger.Schedule\n    cron: \"0 9 * * *\"\n    stopAfter:\n      - FAILED"})}, aliases={"io.kestra.core.models.triggers.types.Schedule"})
@ScheduleValidation
public class Schedule
extends AbstractTrigger
implements Schedulable,
TriggerOutput<Output> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Schedule.class);
    private static final CronDefinitionBuilder CRON_DEFINITION_BUILDER = CronDefinitionBuilder.defineCron().withMinutes().withValidRange(0, 59).withStrictRange().and().withHours().withValidRange(0, 23).withStrictRange().and().withDayOfMonth().withValidRange(1, 31).withStrictRange().and().withMonth().withValidRange(1, 12).withStrictRange().and().withDayOfWeek().withValidRange(0, 7).withMondayDoWValue(1).withIntMapping(7, 0).withStrictRange().and().withSupportedNicknameYearly().withSupportedNicknameAnnually().withSupportedNicknameMonthly().withSupportedNicknameWeekly().withSupportedNicknameDaily().withSupportedNicknameMidnight().withSupportedNicknameHourly();
    private static final CronParser CRON_PARSER = new CronParser(CRON_DEFINITION_BUILDER.instance());
    private static final CronParser CRON_PARSER_WITH_SECONDS = new CronParser(CRON_DEFINITION_BUILDER.withSeconds().withValidRange(0, 59).withStrictRange().and().instance());
    @NotNull
    @Schema(title="The cron expression.", description="A standard [unix cron expression](https://en.wikipedia.org/wiki/Cron) with 5 fields (minutes precision). Using `withSeconds: true` you can switch to 6 fields and a seconds precision.\nBoth `0` and `7` represent Sunday for the day-of-week field.\nCan also be a cron extension / nickname:\n* `@yearly`\n* `@annually`\n* `@monthly`\n* `@weekly`\n* `@daily`\n* `@midnight`\n* `@hourly`")
    @PluginProperty
    private String cron;
    @Schema(title="Whether the cron expression has seconds precision", description="By default, the cron expression has 5 fields. Setting this property to true allows for a 6th field to be used for seconds precision.")
    @NotNull
    @PluginProperty
    private Boolean withSeconds;
    @TimezoneId
    @Schema(title="The [time zone identifier](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones) (i.e. the second column in [the Wikipedia table](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones#List)) to use for evaluating the cron expression. Default value is the server default zone ID.")
    @PluginProperty
    private String timezone;
    @Schema(hidden=true)
    @Null
    private final Duration interval;
    @Valid
    @Schema(title="(Deprecated) Conditions on date. Use `conditions` instead.", description="List of schedule conditions in order to limit the schedule trigger date.")
    @PluginProperty
    @Deprecated
    private List<ScheduleCondition> scheduleConditions;
    @Schema(title="The inputs to pass to the scheduled flow")
    @PluginProperty(dynamic=true)
    private Map<String, Object> inputs;
    @Schema(title="The maximum delay that is accepted", description="If the scheduled execution didn't start after this delay (e.g. due to infrastructure issues), the execution will be skipped.")
    @PluginProperty
    private Duration lateMaximumDelay;
    private transient ExecutionTime executionTime;
    @Schema(title="(Deprecated) Backfill", description="This property is deprecated and will be removed in the future. Instead, you can now go to the Triggers tab and start a highly customizable backfill process directly from the UI. This will allow you to backfill missed scheduled executions by providing a specific date range and custom labels. Read more about it in the [Backfill](https://kestra.io/docs/concepts/backfill) documentation.")
    @PluginProperty
    @Deprecated
    private Map<String, Object> backfill;
    @Schema(title="Action to take in the case of missed schedules", description="`ALL` will recover all missed schedules, `LAST`  will only recovered the last missing one, `NONE` will not recover any missing schedule.\nThe default is `ALL` unless a different value is configured using the global plugin configuration.")
    @PluginProperty
    private RecoverMissedSchedules recoverMissedSchedules;

    @Override
    public List<Condition> getConditions() {
        List<Condition> conditions = Stream.concat(ListUtils.emptyOnNull(this.conditions).stream(), ListUtils.emptyOnNull(this.scheduleConditions).stream().map(c -> (Condition)((Object)c))).toList();
        return conditions.isEmpty() ? null : conditions;
    }

    @Override
    public ZonedDateTime nextEvaluationDate(ConditionContext conditionContext, Optional<? extends TriggerContext> last) {
        ZonedDateTime nextDate;
        ExecutionTime executionTime = this.executionTime();
        Backfill backfill = null;
        if (last.isPresent() && (last.get().getBackfill() != null || last.get().getDate() != null)) {
            ZonedDateTime lastDate;
            if (last.get().getBackfill() != null) {
                backfill = last.get().getBackfill();
                lastDate = this.convertDateTime(backfill.getCurrentDate());
            } else {
                lastDate = this.convertDateTime(last.get().getDate());
            }
            if (this.getConditions() != null) {
                try {
                    Optional<ZonedDateTime> next = this.truePreviousNextDateWithCondition(executionTime, conditionContext, lastDate, true);
                    if (next.isPresent()) {
                        return next.get().truncatedTo(ChronoUnit.SECONDS);
                    }
                }
                catch (InternalException e) {
                    conditionContext.getRunContext().logger().warn("Unable to evaluate the conditions for the next evaluation date for trigger '{}', conditions will not be evaluated", (Object)this.getId());
                }
            }
            nextDate = this.computeNextEvaluationDate(executionTime, lastDate).orElse(null);
            if (backfill != null && nextDate != null && nextDate.isAfter(backfill.getEnd())) {
                nextDate = this.computeNextEvaluationDate(executionTime, this.convertDateTime(ZonedDateTime.now())).orElse(null);
            }
        } else {
            nextDate = this.computeNextEvaluationDate(executionTime, this.convertDateTime(ZonedDateTime.now())).orElse(null);
        }
        if (this.lateMaximumDelay != null && nextDate != null && backfill == null) {
            Output scheduleDates = this.scheduleDates(executionTime, nextDate).orElse(null);
            if ((scheduleDates = this.handleMaxDelay(scheduleDates)) != null) {
                nextDate = scheduleDates.getDate();
            } else {
                return null;
            }
        }
        return nextDate;
    }

    @Override
    public ZonedDateTime nextEvaluationDate() {
        ExecutionTime executionTime = this.executionTime();
        return this.computeNextEvaluationDate(executionTime, this.convertDateTime(ZonedDateTime.now())).orElse(this.convertDateTime(ZonedDateTime.now()));
    }

    @Override
    public ZonedDateTime previousEvaluationDate(ConditionContext conditionContext) {
        ExecutionTime executionTime = this.executionTime();
        if (this.getConditions() != null) {
            try {
                Optional<ZonedDateTime> previous = this.truePreviousNextDateWithCondition(executionTime, conditionContext, ZonedDateTime.now(), false);
                if (previous.isPresent()) {
                    return previous.get().truncatedTo(ChronoUnit.SECONDS);
                }
            }
            catch (InternalException e) {
                conditionContext.getRunContext().logger().warn("Unable to evaluate the conditions for the next evaluation date for trigger '{}', conditions will not be evaluated", (Object)this.getId());
            }
        }
        return this.computePreviousEvaluationDate(executionTime, this.convertDateTime(ZonedDateTime.now())).orElse(this.convertDateTime(ZonedDateTime.now()));
    }

    @Override
    public Optional<Execution> evaluate(ConditionContext conditionContext, TriggerContext triggerContext) throws Exception {
        Output scheduleDates;
        RunContext runContext = conditionContext.getRunContext();
        ExecutionTime executionTime = this.executionTime();
        ZonedDateTime currentDateTimeExecution = this.convertDateTime(triggerContext.getDate());
        Backfill backfill = triggerContext.getBackfill();
        if (backfill != null) {
            if (backfill.getPaused().booleanValue()) {
                return Optional.empty();
            }
            currentDateTimeExecution = this.convertDateTime(backfill.getCurrentDate());
        }
        if ((scheduleDates = (Output)this.scheduleDates(executionTime, currentDateTimeExecution).orElse(null)) == null || scheduleDates.getDate() == null) {
            return Optional.empty();
        }
        ZonedDateTime next = scheduleDates.getDate();
        if (backfill != null && currentDateTimeExecution.isBefore(next)) {
            return Optional.empty();
        }
        if (next.compareTo(ZonedDateTime.now().plus(Duration.ofSeconds(1L))) > 0) {
            if (log.isTraceEnabled()) {
                log.trace("Schedule is in the future, execution skipped, this behavior should never happen.");
            }
            return Optional.empty();
        }
        conditionContext = this.conditionContext(conditionContext, scheduleDates);
        if (this.getConditions() != null) {
            try {
                boolean conditionResults = this.validateScheduleCondition(conditionContext);
                if (!conditionResults) {
                    return Optional.empty();
                }
            }
            catch (InternalException ie) {
                runContext.logger().error("Unable to evaluate the Schedule trigger '{}'", (Object)this.getId(), (Object)ie);
                Execution execution = Execution.builder().id(runContext.getTriggerExecutionId()).tenantId(triggerContext.getTenantId()).namespace(triggerContext.getNamespace()).flowId(triggerContext.getFlowId()).flowRevision(conditionContext.getFlow().getRevision()).labels(this.generateLabels(runContext, conditionContext, backfill)).state(new State().withState(State.Type.FAILED)).build();
                return Optional.of(execution);
            }
            scheduleDates = this.trueOutputWithCondition(executionTime, conditionContext, scheduleDates);
        }
        Map<String, Object> variables = this.timezone != null ? scheduleDates.toMap(ZoneId.of(this.timezone)) : scheduleDates.toMap();
        Execution execution = TriggerService.generateScheduledExecution(this, conditionContext, triggerContext, this.generateLabels(runContext, conditionContext, backfill), this.generateInputs(runContext, backfill), variables, Optional.empty());
        return Optional.of(execution);
    }

    public Cron parseCron() {
        CronParser parser = Boolean.TRUE.equals(this.withSeconds) ? CRON_PARSER_WITH_SECONDS : CRON_PARSER;
        return parser.parse(this.cron);
    }

    private List<Label> generateLabels(RunContext runContext, ConditionContext conditionContext, Backfill backfill) throws IllegalVariableEvaluationException {
        List<Label> labels = LabelService.fromTrigger(runContext, conditionContext.getFlow(), this);
        if (backfill != null && backfill.getLabels() != null) {
            for (Label label : backfill.getLabels()) {
                String value = runContext.render(label.value());
                if (value == null) continue;
                labels.add(new Label(label.key(), value));
            }
        }
        return labels;
    }

    private Map<String, Object> generateInputs(RunContext runContext, Backfill backfill) throws IllegalVariableEvaluationException {
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        if (this.inputs != null) {
            inputs.putAll(runContext.render(this.inputs));
        }
        if (backfill != null && backfill.getInputs() != null) {
            inputs.putAll(runContext.render(backfill.getInputs()));
        }
        return inputs;
    }

    private Optional<Output> scheduleDates(ExecutionTime executionTime, ZonedDateTime date) {
        Optional next = executionTime.nextExecution(date.minus(Duration.ofSeconds(1L)));
        if (next.isEmpty()) {
            return Optional.empty();
        }
        Object outputDatesBuilder = Output.builder().date(this.convertDateTime((ZonedDateTime)next.get()));
        this.computeNextEvaluationDate(executionTime, (ZonedDateTime)next.get()).map(this::convertDateTime).ifPresent(arg_0 -> outputDatesBuilder.next(arg_0));
        executionTime.lastExecution(date).map(this::convertDateTime).ifPresent(arg_0 -> outputDatesBuilder.previous(arg_0));
        Object scheduleDates = ((Output.OutputBuilder)outputDatesBuilder).build();
        return Optional.of(scheduleDates);
    }

    private ConditionContext conditionContext(ConditionContext conditionContext, Output output) {
        return conditionContext.withVariables((Map<String, Object>)ImmutableMap.of((Object)"schedule", output.toMap(), (Object)"trigger", output.toMap()));
    }

    private synchronized ExecutionTime executionTime() {
        if (this.executionTime == null) {
            Cron parsed = this.parseCron();
            this.executionTime = ExecutionTime.forCron((Cron)parsed);
        }
        return this.executionTime;
    }

    private ZonedDateTime convertDateTime(ZonedDateTime date) {
        if (this.timezone == null) {
            return date;
        }
        return date.withZoneSameInstant(ZoneId.of(this.timezone));
    }

    private Optional<ZonedDateTime> computeNextEvaluationDate(ExecutionTime executionTime, ZonedDateTime date) {
        return executionTime.nextExecution(date).map(zonedDateTime -> zonedDateTime.truncatedTo(ChronoUnit.SECONDS));
    }

    private Optional<ZonedDateTime> computePreviousEvaluationDate(ExecutionTime executionTime, ZonedDateTime date) {
        return executionTime.lastExecution(date).map(zonedDateTime -> zonedDateTime.truncatedTo(ChronoUnit.SECONDS));
    }

    private Output trueOutputWithCondition(ExecutionTime executionTime, ConditionContext conditionContext, Output output) throws InternalException {
        Object outputBuilder = Output.builder().date(output.getDate());
        this.truePreviousNextDateWithCondition(executionTime, conditionContext, output.getDate(), true).ifPresent(arg_0 -> outputBuilder.next(arg_0));
        this.truePreviousNextDateWithCondition(executionTime, conditionContext, output.getDate(), false).ifPresent(arg_0 -> outputBuilder.previous(arg_0));
        return ((Output.OutputBuilder)outputBuilder).build();
    }

    private Optional<ZonedDateTime> truePreviousNextDateWithCondition(ExecutionTime executionTime, ConditionContext conditionContext, ZonedDateTime toTestDate, boolean next) throws InternalException {
        while (next && toTestDate.getYear() < ZonedDateTime.now().getYear() + 10 || !next && toTestDate.getYear() > ZonedDateTime.now().getYear() - 10) {
            Optional currentDate;
            Optional optional = currentDate = next ? executionTime.nextExecution(toTestDate) : executionTime.lastExecution(toTestDate);
            if (currentDate.isEmpty()) {
                return currentDate;
            }
            Optional<Output> currentOutput = this.scheduleDates(executionTime, (ZonedDateTime)currentDate.get());
            if (currentOutput.isEmpty()) {
                return Optional.empty();
            }
            ConditionContext currentConditionContext = this.conditionContext(conditionContext, currentOutput.get());
            boolean conditionResults = this.validateScheduleCondition(currentConditionContext);
            if (conditionResults) {
                return currentDate;
            }
            toTestDate = (ZonedDateTime)currentDate.get();
        }
        return Optional.empty();
    }

    private Output handleMaxDelay(Output output) {
        if (output == null) {
            return null;
        }
        if (this.lateMaximumDelay == null) {
            return output;
        }
        while (output.getDate().getYear() < ZonedDateTime.now().getYear() + 10 || output.getDate().getYear() > ZonedDateTime.now().getYear() - 10) {
            if (output.getDate().plus(this.lateMaximumDelay).compareTo(ZonedDateTime.now()) < 0) {
                if ((output = (Output)this.scheduleDates(this.executionTime, output.getNext()).orElse(null)) != null) continue;
                return null;
            }
            return output;
        }
        return output;
    }

    private boolean validateScheduleCondition(ConditionContext conditionContext) throws InternalException {
        if (this.conditions != null) {
            ConditionService conditionService = (ConditionService)((DefaultRunContext)conditionContext.getRunContext()).getApplicationContext().getBean(ConditionService.class);
            return conditionService.isValid(this.conditions.stream().filter(c -> c instanceof ScheduleCondition).map(c -> (ScheduleCondition)((Object)c)).toList(), conditionContext);
        }
        return true;
    }

    @Generated
    private static Boolean $default$withSeconds() {
        return false;
    }

    @Generated
    private static String $default$timezone() {
        return ZoneId.systemDefault().toString();
    }

    @Generated
    private static Duration $default$interval() {
        return null;
    }

    @Generated
    protected Schedule(ScheduleBuilder<?, ?> b) {
        super(b);
        this.cron = b.cron;
        this.withSeconds = b.withSeconds$set ? b.withSeconds$value : Schedule.$default$withSeconds();
        this.timezone = b.timezone$set ? b.timezone$value : Schedule.$default$timezone();
        this.interval = b.interval$set ? b.interval$value : Schedule.$default$interval();
        this.scheduleConditions = b.scheduleConditions;
        this.inputs = b.inputs;
        this.lateMaximumDelay = b.lateMaximumDelay;
        this.executionTime = b.executionTime;
        this.backfill = b.backfill;
        this.recoverMissedSchedules = b.recoverMissedSchedules;
    }

    @Generated
    public static ScheduleBuilder<?, ?> builder() {
        return new ScheduleBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Schedule(super=" + super.toString() + ", cron=" + this.getCron() + ", withSeconds=" + this.getWithSeconds() + ", timezone=" + this.getTimezone() + ", interval=" + String.valueOf(this.getInterval()) + ", scheduleConditions=" + String.valueOf(this.getScheduleConditions()) + ", inputs=" + String.valueOf(this.getInputs()) + ", lateMaximumDelay=" + String.valueOf(this.getLateMaximumDelay()) + ", executionTime=" + String.valueOf(this.executionTime) + ", backfill=" + String.valueOf(this.getBackfill()) + ", recoverMissedSchedules=" + String.valueOf((Object)this.getRecoverMissedSchedules()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Schedule)) {
            return false;
        }
        Schedule other = (Schedule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$withSeconds = this.getWithSeconds();
        Boolean other$withSeconds = other.getWithSeconds();
        if (this$withSeconds == null ? other$withSeconds != null : !((Object)this$withSeconds).equals(other$withSeconds)) {
            return false;
        }
        String this$cron = this.getCron();
        String other$cron = other.getCron();
        if (this$cron == null ? other$cron != null : !this$cron.equals(other$cron)) {
            return false;
        }
        String this$timezone = this.getTimezone();
        String other$timezone = other.getTimezone();
        if (this$timezone == null ? other$timezone != null : !this$timezone.equals(other$timezone)) {
            return false;
        }
        Duration this$interval = this.getInterval();
        Duration other$interval = other.getInterval();
        if (this$interval == null ? other$interval != null : !((Object)this$interval).equals(other$interval)) {
            return false;
        }
        List<ScheduleCondition> this$scheduleConditions = this.getScheduleConditions();
        List<ScheduleCondition> other$scheduleConditions = other.getScheduleConditions();
        if (this$scheduleConditions == null ? other$scheduleConditions != null : !((Object)this$scheduleConditions).equals(other$scheduleConditions)) {
            return false;
        }
        Map<String, Object> this$inputs = this.getInputs();
        Map<String, Object> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
            return false;
        }
        Duration this$lateMaximumDelay = this.getLateMaximumDelay();
        Duration other$lateMaximumDelay = other.getLateMaximumDelay();
        if (this$lateMaximumDelay == null ? other$lateMaximumDelay != null : !((Object)this$lateMaximumDelay).equals(other$lateMaximumDelay)) {
            return false;
        }
        Map<String, Object> this$backfill = this.getBackfill();
        Map<String, Object> other$backfill = other.getBackfill();
        if (this$backfill == null ? other$backfill != null : !((Object)this$backfill).equals(other$backfill)) {
            return false;
        }
        RecoverMissedSchedules this$recoverMissedSchedules = this.getRecoverMissedSchedules();
        RecoverMissedSchedules other$recoverMissedSchedules = other.getRecoverMissedSchedules();
        return !(this$recoverMissedSchedules == null ? other$recoverMissedSchedules != null : !((Object)((Object)this$recoverMissedSchedules)).equals((Object)other$recoverMissedSchedules));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Schedule;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $withSeconds = this.getWithSeconds();
        result = result * 59 + ($withSeconds == null ? 43 : ((Object)$withSeconds).hashCode());
        String $cron = this.getCron();
        result = result * 59 + ($cron == null ? 43 : $cron.hashCode());
        String $timezone = this.getTimezone();
        result = result * 59 + ($timezone == null ? 43 : $timezone.hashCode());
        Duration $interval = this.getInterval();
        result = result * 59 + ($interval == null ? 43 : ((Object)$interval).hashCode());
        List<ScheduleCondition> $scheduleConditions = this.getScheduleConditions();
        result = result * 59 + ($scheduleConditions == null ? 43 : ((Object)$scheduleConditions).hashCode());
        Map<String, Object> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        Duration $lateMaximumDelay = this.getLateMaximumDelay();
        result = result * 59 + ($lateMaximumDelay == null ? 43 : ((Object)$lateMaximumDelay).hashCode());
        Map<String, Object> $backfill = this.getBackfill();
        result = result * 59 + ($backfill == null ? 43 : ((Object)$backfill).hashCode());
        RecoverMissedSchedules $recoverMissedSchedules = this.getRecoverMissedSchedules();
        result = result * 59 + ($recoverMissedSchedules == null ? 43 : ((Object)((Object)$recoverMissedSchedules)).hashCode());
        return result;
    }

    @Generated
    public String getCron() {
        return this.cron;
    }

    @Generated
    public Boolean getWithSeconds() {
        return this.withSeconds;
    }

    @Generated
    public String getTimezone() {
        return this.timezone;
    }

    @Override
    @Generated
    public Duration getInterval() {
        return this.interval;
    }

    @Deprecated
    @Generated
    public List<ScheduleCondition> getScheduleConditions() {
        return this.scheduleConditions;
    }

    @Generated
    public Map<String, Object> getInputs() {
        return this.inputs;
    }

    @Generated
    public Duration getLateMaximumDelay() {
        return this.lateMaximumDelay;
    }

    @Deprecated
    @Generated
    public Map<String, Object> getBackfill() {
        return this.backfill;
    }

    @Override
    @Generated
    public RecoverMissedSchedules getRecoverMissedSchedules() {
        return this.recoverMissedSchedules;
    }

    @Generated
    public Schedule() {
        this.withSeconds = Schedule.$default$withSeconds();
        this.timezone = Schedule.$default$timezone();
        this.interval = Schedule.$default$interval();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The date of the current schedule.")
        @NotNull
        private ZonedDateTime date;
        @Schema(title="The date of the next schedule")
        @NotNull
        private ZonedDateTime next;
        @Schema(title="The date of the previous schedule")
        @NotNull
        private ZonedDateTime previous;

        @Generated
        protected Output(OutputBuilder<?, ?> b) {
            this.date = b.date;
            this.next = b.next;
            this.previous = b.previous;
        }

        @Generated
        public static OutputBuilder<?, ?> builder() {
            return new OutputBuilderImpl();
        }

        @Generated
        public String toString() {
            return "Schedule.Output(date=" + String.valueOf(this.getDate()) + ", next=" + String.valueOf(this.getNext()) + ", previous=" + String.valueOf(this.getPrevious()) + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Output)) {
                return false;
            }
            Output other = (Output)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ZonedDateTime this$date = this.getDate();
            ZonedDateTime other$date = other.getDate();
            if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
                return false;
            }
            ZonedDateTime this$next = this.getNext();
            ZonedDateTime other$next = other.getNext();
            if (this$next == null ? other$next != null : !((Object)this$next).equals(other$next)) {
                return false;
            }
            ZonedDateTime this$previous = this.getPrevious();
            ZonedDateTime other$previous = other.getPrevious();
            return !(this$previous == null ? other$previous != null : !((Object)this$previous).equals(other$previous));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Output;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ZonedDateTime $date = this.getDate();
            result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
            ZonedDateTime $next = this.getNext();
            result = result * 59 + ($next == null ? 43 : ((Object)$next).hashCode());
            ZonedDateTime $previous = this.getPrevious();
            result = result * 59 + ($previous == null ? 43 : ((Object)$previous).hashCode());
            return result;
        }

        @Generated
        public ZonedDateTime getDate() {
            return this.date;
        }

        @Generated
        public ZonedDateTime getNext() {
            return this.next;
        }

        @Generated
        public ZonedDateTime getPrevious() {
            return this.previous;
        }

        @Generated
        public Output() {
        }

        @Generated
        public static abstract class OutputBuilder<C extends Output, B extends OutputBuilder<C, B>> {
            @Generated
            private ZonedDateTime date;
            @Generated
            private ZonedDateTime next;
            @Generated
            private ZonedDateTime previous;

            @Generated
            public B date(ZonedDateTime date) {
                this.date = date;
                return this.self();
            }

            @Generated
            public B next(ZonedDateTime next) {
                this.next = next;
                return this.self();
            }

            @Generated
            public B previous(ZonedDateTime previous) {
                this.previous = previous;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "Schedule.Output.OutputBuilder(date=" + String.valueOf(this.date) + ", next=" + String.valueOf(this.next) + ", previous=" + String.valueOf(this.previous) + ")";
            }
        }

        @Generated
        private static final class OutputBuilderImpl
        extends OutputBuilder<Output, OutputBuilderImpl> {
            @Generated
            private OutputBuilderImpl() {
            }

            @Override
            @Generated
            protected OutputBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public Output build() {
                return new Output(this);
            }
        }
    }

    @Generated
    public static abstract class ScheduleBuilder<C extends Schedule, B extends ScheduleBuilder<C, B>>
    extends AbstractTrigger.AbstractTriggerBuilder<C, B> {
        @Generated
        private String cron;
        @Generated
        private boolean withSeconds$set;
        @Generated
        private Boolean withSeconds$value;
        @Generated
        private boolean timezone$set;
        @Generated
        private String timezone$value;
        @Generated
        private boolean interval$set;
        @Generated
        private Duration interval$value;
        @Generated
        private List<ScheduleCondition> scheduleConditions;
        @Generated
        private Map<String, Object> inputs;
        @Generated
        private Duration lateMaximumDelay;
        @Generated
        private ExecutionTime executionTime;
        @Generated
        private Map<String, Object> backfill;
        @Generated
        private RecoverMissedSchedules recoverMissedSchedules;

        @Generated
        public B cron(String cron) {
            this.cron = cron;
            return (B)this.self();
        }

        @Generated
        public B withSeconds(Boolean withSeconds) {
            this.withSeconds$value = withSeconds;
            this.withSeconds$set = true;
            return (B)this.self();
        }

        @Generated
        public B timezone(String timezone) {
            this.timezone$value = timezone;
            this.timezone$set = true;
            return (B)this.self();
        }

        @Generated
        public B interval(Duration interval) {
            this.interval$value = interval;
            this.interval$set = true;
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B scheduleConditions(List<ScheduleCondition> scheduleConditions) {
            this.scheduleConditions = scheduleConditions;
            return (B)this.self();
        }

        @Generated
        public B inputs(Map<String, Object> inputs) {
            this.inputs = inputs;
            return (B)this.self();
        }

        @Generated
        public B lateMaximumDelay(Duration lateMaximumDelay) {
            this.lateMaximumDelay = lateMaximumDelay;
            return (B)this.self();
        }

        @Generated
        public B executionTime(ExecutionTime executionTime) {
            this.executionTime = executionTime;
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B backfill(Map<String, Object> backfill) {
            this.backfill = backfill;
            return (B)this.self();
        }

        @Generated
        public B recoverMissedSchedules(RecoverMissedSchedules recoverMissedSchedules) {
            this.recoverMissedSchedules = recoverMissedSchedules;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Schedule.ScheduleBuilder(super=" + super.toString() + ", cron=" + this.cron + ", withSeconds$value=" + this.withSeconds$value + ", timezone$value=" + this.timezone$value + ", interval$value=" + String.valueOf(this.interval$value) + ", scheduleConditions=" + String.valueOf(this.scheduleConditions) + ", inputs=" + String.valueOf(this.inputs) + ", lateMaximumDelay=" + String.valueOf(this.lateMaximumDelay) + ", executionTime=" + String.valueOf(this.executionTime) + ", backfill=" + String.valueOf(this.backfill) + ", recoverMissedSchedules=" + String.valueOf((Object)this.recoverMissedSchedules) + ")";
        }
    }

    @Generated
    private static final class ScheduleBuilderImpl
    extends ScheduleBuilder<Schedule, ScheduleBuilderImpl> {
        @Generated
        private ScheduleBuilderImpl() {
        }

        @Override
        @Generated
        protected ScheduleBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Schedule build() {
            return new Schedule(this);
        }
    }
}

