/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.trigger;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.ExecutionTrigger;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.TriggerOutput;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.validations.WebhookValidation;
import io.micronaut.http.HttpRequest;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

@Schema(title="Execute a flow from an API call triggered by a webhook.", description="Webhook trigger allows you to create a unique URL that you can use to trigger a Kestra flow execution based on events in another application such as GitHub or Amazon EventBridge. In order to use that URL, you have to add a secret key to secure your webhook URL.\n\nThe URL will then follow the following format: `https://{your_hostname}/api/v1/executions/webhook/{namespace}/{flowId}/{key}`. Replace the templated values according to your workflow setup.\n\nThe webhook URL accepts `GET`, `POST`, and `PUT` requests.\n\nYou can access the request body and headers sent by another application using the following template variables:\n- `{{ trigger.body }}`\n- `{{ trigger.headers }}`\n\nThe webhook response will be one of the following HTTP status codes:\n- 404 if the namespace, flow, or webhook key is not found.\n- 200 if the webhook triggers an execution.\n- 204 if the webhook cannot trigger an execution due to a lack of matching event conditions sent by other application.\n\nThe response body will contain the execution ID if the execution is successfully triggered using the following format:\n```json\n{\n  \"tenantId\": \"your_tenant_id\",\n  \"namespace\": \"your_namespace\",\n  \"flowId\": \"your_flow_id\",\n  \"flowRevision\": 1,\n  \"trigger\": {\n    \"id\": \"the_trigger_id\",\n    \"type\": \"io.kestra.plugin.core.trigger.Webhook\",\n    \"variables\": {\n        # The variables sent by the webhook caller\n    },\n    \"logFile\": \"the_log_file_url\"\n  },\n  \"outputs\": {\n    # The outputs of the flow, only available if `wait` is set to true\n  },\n  \"labels\": [\n    {\"key\": \"value\" }\n  ],\n  \"state\": {\n    \"type\": \"RUNNING\",\n    \"histories\": [\n      # The state histories of the execution\n    ]\n   },\n   \"url\": \"the_execution_url_inside_ui\",\n}\n```\nIf you set the `wait` property to `true` and `returnOutputs` to `true`, the webhook call will wait for the flow to finish and return the flow outputs as response.\n\nA webhook trigger can have conditions, but it doesn't support conditions of type `MultipleCondition`.")
@Plugin(examples={@Example(title="Add a webhook trigger to the current flow with the key `4wjtkzwVGBM9yKnjm3yv8r`; the webhook will be available at the URI `/api/v1/executions/webhook/{namespace}/{flowId}/4wjtkzwVGBM9yKnjm3yv8r`.", code={"id: webhook_flow\nnamespace: company.team\n\ntasks:\n  - id: log_hello_world\n    type: io.kestra.plugin.core.log.Log\n    message: Hello World! \ud83d\ude80\n\ntriggers:\n  - id: webhook\n    type: io.kestra.plugin.core.trigger.Webhook\n    key: 4wjtkzwVGBM9yKnjm3yv8r\n"}, full=true), @Example(title="Add a trigger matching specific webhook event condition. The flow will be executed only if the condition is met.\n", code={"id: condition_based_webhook_flow\nnamespace: company.team\n\ntasks:\n  - id: log_hello_world\n    type: io.kestra.plugin.core.log.Log\n    message: Hello World! \ud83d\ude80\n\ntriggers:\n  - id: webhook\n    type: io.kestra.plugin.core.trigger.Webhook\n    key: 4wjtkzwVGBM9yKnjm3yv8r\n    conditions:\n      - type: io.kestra.plugin.core.condition.Expression\n        expression: \"{{ trigger.body.hello == 'world' }}\"\n"}, full=true)}, aliases={"io.kestra.core.models.triggers.types.Webhook"})
@WebhookValidation
public class Webhook
extends AbstractTrigger
implements TriggerOutput<Output> {
    private static final ObjectMapper MAPPER = JacksonMapper.ofJson().copy().setDefaultPropertyInclusion(JsonInclude.Include.USE_DEFAULTS);
    @Size(max=256)
    @NotNull
    @Schema(title="The unique key that will be part of the URL.", description="The key is used for generating the webhook URL.\n\n::alert{type=\"warning\"}\nMake sure to keep the webhook key secure. It's the only security mechanism to protect your endpoint from bad actors, and must be considered as a secret. You can use a random key generator to create the key.\n::\n")
    @PluginProperty(dynamic=true)
    private @Size(max=256) @NotNull String key;
    @PluginProperty
    @Schema(title="Wait for the flow to finish.", description=" If set to `true` the webhook call will wait for the flow to finish and return the flow outputs as response.\n If set to `false` the webhook call will return immediately after the execution is created.\n")
    private Boolean wait;
    @Schema(title="The inputs to pass to the triggered flow")
    @PluginProperty(dynamic=true)
    private Map<String, Object> inputs;
    @PluginProperty
    @Schema(title="Send outputs of the flows as response for webhook caller.", description="Requires `wait` to be `true`.")
    private Boolean returnOutputs;

    public Optional<Execution> evaluate(HttpRequest<String> request, Flow flow) {
        String body = request.getBody().orElse(null);
        Execution.ExecutionBuilder builder = Execution.builder().id(IdUtils.create()).tenantId(flow.getTenantId()).namespace(flow.getNamespace()).flowId(flow.getId()).flowRevision(flow.getRevision()).inputs(this.inputs).state(new State()).trigger(ExecutionTrigger.of((AbstractTrigger)this, Output.builder().body(this.tryMap(body).or(() -> this.tryArray(body)).orElse(body)).headers(request.getHeaders().asMap()).parameters(request.getParameters().asMap()).build()));
        return Optional.of(builder.build());
    }

    private Optional<Object> tryMap(String body) {
        try {
            return Optional.of(MAPPER.readValue(body, (TypeReference)new TypeReference<Map<String, Object>>(this){}));
        }
        catch (Exception ignored) {
            return Optional.empty();
        }
    }

    private Optional<Object> tryArray(String body) {
        try {
            return Optional.of(MAPPER.readValue(body, (TypeReference)new TypeReference<List<Object>>(this){}));
        }
        catch (Exception ignored) {
            return Optional.empty();
        }
    }

    @Generated
    private static Boolean $default$wait() {
        return false;
    }

    @Generated
    private static Boolean $default$returnOutputs() {
        return false;
    }

    @Generated
    protected Webhook(WebhookBuilder<?, ?> b) {
        super(b);
        this.key = b.key;
        this.wait = b.wait$set ? b.wait$value : Webhook.$default$wait();
        this.inputs = b.inputs;
        this.returnOutputs = b.returnOutputs$set ? b.returnOutputs$value : Webhook.$default$returnOutputs();
    }

    @Generated
    public static WebhookBuilder<?, ?> builder() {
        return new WebhookBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Webhook(super=" + super.toString() + ", key=" + this.getKey() + ", wait=" + this.getWait() + ", inputs=" + String.valueOf(this.getInputs()) + ", returnOutputs=" + this.getReturnOutputs() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Webhook)) {
            return false;
        }
        Webhook other = (Webhook)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$wait = this.getWait();
        Boolean other$wait = other.getWait();
        if (this$wait == null ? other$wait != null : !((Object)this$wait).equals(other$wait)) {
            return false;
        }
        Boolean this$returnOutputs = this.getReturnOutputs();
        Boolean other$returnOutputs = other.getReturnOutputs();
        if (this$returnOutputs == null ? other$returnOutputs != null : !((Object)this$returnOutputs).equals(other$returnOutputs)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        Map<String, Object> this$inputs = this.getInputs();
        Map<String, Object> other$inputs = other.getInputs();
        return !(this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Webhook;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $wait = this.getWait();
        result = result * 59 + ($wait == null ? 43 : ((Object)$wait).hashCode());
        Boolean $returnOutputs = this.getReturnOutputs();
        result = result * 59 + ($returnOutputs == null ? 43 : ((Object)$returnOutputs).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        Map<String, Object> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        return result;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public Boolean getWait() {
        return this.wait;
    }

    @Generated
    public Map<String, Object> getInputs() {
        return this.inputs;
    }

    @Generated
    public Boolean getReturnOutputs() {
        return this.returnOutputs;
    }

    @Generated
    public Webhook() {
        this.wait = Webhook.$default$wait();
        this.returnOutputs = Webhook.$default$returnOutputs();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The full body for the webhook request", description="We try to deserialize the incoming request as JSON (array or object).\nIf we can't deserialize, the full body will be available as a string.")
        @NotNull
        private Object body;
        @Schema(title="The headers for the webhook request")
        @NotNull
        private Map<String, List<String>> headers;
        @Schema(title="The parameters for the webhook request")
        @NotNull
        private Map<String, List<String>> parameters;

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public String toString() {
            return "Webhook.Output(body=" + String.valueOf(this.getBody()) + ", headers=" + String.valueOf(this.getHeaders()) + ", parameters=" + String.valueOf(this.getParameters()) + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Output)) {
                return false;
            }
            Output other = (Output)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Object this$body = this.getBody();
            Object other$body = other.getBody();
            if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
                return false;
            }
            Map<String, List<String>> this$headers = this.getHeaders();
            Map<String, List<String>> other$headers = other.getHeaders();
            if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
                return false;
            }
            Map<String, List<String>> this$parameters = this.getParameters();
            Map<String, List<String>> other$parameters = other.getParameters();
            return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Output;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            Map<String, List<String>> $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            Map<String, List<String>> $parameters = this.getParameters();
            result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
            return result;
        }

        @Generated
        public Object getBody() {
            return this.body;
        }

        @Generated
        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        @Generated
        public Map<String, List<String>> getParameters() {
            return this.parameters;
        }

        @Generated
        public Output() {
        }

        @ConstructorProperties(value={"body", "headers", "parameters"})
        @Generated
        public Output(Object body, Map<String, List<String>> headers, Map<String, List<String>> parameters) {
            this.body = body;
            this.headers = headers;
            this.parameters = parameters;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private Object body;
            @Generated
            private Map<String, List<String>> headers;
            @Generated
            private Map<String, List<String>> parameters;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder body(Object body) {
                this.body = body;
                return this;
            }

            @Generated
            public OutputBuilder headers(Map<String, List<String>> headers) {
                this.headers = headers;
                return this;
            }

            @Generated
            public OutputBuilder parameters(Map<String, List<String>> parameters) {
                this.parameters = parameters;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.body, this.headers, this.parameters);
            }

            @Generated
            public String toString() {
                return "Webhook.Output.OutputBuilder(body=" + String.valueOf(this.body) + ", headers=" + String.valueOf(this.headers) + ", parameters=" + String.valueOf(this.parameters) + ")";
            }
        }
    }

    @Generated
    public static abstract class WebhookBuilder<C extends Webhook, B extends WebhookBuilder<C, B>>
    extends AbstractTrigger.AbstractTriggerBuilder<C, B> {
        @Generated
        private String key;
        @Generated
        private boolean wait$set;
        @Generated
        private Boolean wait$value;
        @Generated
        private Map<String, Object> inputs;
        @Generated
        private boolean returnOutputs$set;
        @Generated
        private Boolean returnOutputs$value;

        @Generated
        public B key(String key) {
            this.key = key;
            return (B)this.self();
        }

        @Generated
        public B wait(Boolean wait) {
            this.wait$value = wait;
            this.wait$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputs(Map<String, Object> inputs) {
            this.inputs = inputs;
            return (B)this.self();
        }

        @Generated
        public B returnOutputs(Boolean returnOutputs) {
            this.returnOutputs$value = returnOutputs;
            this.returnOutputs$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Webhook.WebhookBuilder(super=" + super.toString() + ", key=" + this.key + ", wait$value=" + this.wait$value + ", inputs=" + String.valueOf(this.inputs) + ", returnOutputs$value=" + this.returnOutputs$value + ")";
        }
    }

    @Generated
    private static final class WebhookBuilderImpl
    extends WebhookBuilder<Webhook, WebhookBuilderImpl> {
        @Generated
        private WebhookBuilderImpl() {
        }

        @Override
        @Generated
        protected WebhookBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Webhook build() {
            return new Webhook(this);
        }
    }
}

