/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class NoopCache<K, V>
implements Cache<K, V> {
    private static final ConcurrentMap<?, ?> EMPTY_MAP = new ConcurrentHashMap(0);

    public @Nullable V getIfPresent(K key) {
        return null;
    }

    public V get(K key, Function<? super K, ? extends V> mappingFunction) {
        return mappingFunction.apply(key);
    }

    public Map<K, @NonNull V> getAllPresent(Iterable<? extends K> keys) {
        return Collections.emptyMap();
    }

    public Map<K, @NonNull V> getAll(Iterable<? extends K> keys, Function<? super Set<? extends K>, ? extends Map<? extends K, ? extends @NonNull V>> mappingFunction) {
        return Collections.emptyMap();
    }

    public void put(K key, @NonNull V value) {
    }

    public void putAll(Map<? extends K, ? extends @NonNull V> map) {
    }

    public void invalidate(K key) {
    }

    public void invalidateAll(Iterable<? extends K> keys) {
    }

    public void invalidateAll() {
    }

    public long estimatedSize() {
        return 0L;
    }

    public CacheStats stats() {
        return CacheStats.empty();
    }

    public ConcurrentMap<K, @NonNull V> asMap() {
        return EMPTY_MAP;
    }

    public void cleanUp() {
    }

    public Policy<K, @NonNull V> policy() {
        throw new UnsupportedOperationException();
    }
}

