/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.contexts;

import io.kestra.core.models.ServerType;
import io.kestra.core.plugins.PluginRegistry;
import io.kestra.core.storages.StorageInterface;
import io.kestra.core.utils.VersionProvider;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertySource;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KestraContext {
    private static final Logger log = LoggerFactory.getLogger(KestraContext.class);
    private static final AtomicReference<KestraContext> INSTANCE = new AtomicReference();
    public static final String KESTRA_SERVER_TYPE = "kestra.server-type";
    private static final String KESTRA_WORKER_MAX_NUM_THREADS = "kestra.worker.max-num-threads";
    private static final String KESTRA_WORKER_GROUP_KEY = "kestra.worker.group-key";

    public static KestraContext getContext() {
        return Optional.ofNullable(INSTANCE.get()).orElseThrow(() -> new IllegalStateException("Kestra context not initialized"));
    }

    public static void setContext(KestraContext context) {
        INSTANCE.set(context);
    }

    public abstract ServerType getServerType();

    public abstract Optional<Integer> getWorkerMaxNumThreads();

    public abstract Optional<String> getWorkerGroupKey();

    public abstract void injectWorkerConfigs(Integer var1, String var2);

    public abstract String getVersion();

    public abstract PluginRegistry getPluginRegistry();

    public abstract StorageInterface getStorageInterface();

    public void shutdown() {
    }

    @Context
    @Requires(missingBeans={KestraContext.class})
    public static class Initializer
    extends KestraContext {
        private final ApplicationContext applicationContext;
        private final Environment environment;
        private final String version;
        private final AtomicBoolean isShutdown = new AtomicBoolean(false);

        public Initializer(ApplicationContext applicationContext, Environment environment) {
            this.applicationContext = applicationContext;
            this.version = Optional.ofNullable((VersionProvider)applicationContext.getBean(VersionProvider.class)).map(VersionProvider::getVersion).orElse(null);
            this.environment = environment;
            KestraContext.setContext(this);
        }

        @Override
        public ServerType getServerType() {
            return Optional.ofNullable(this.environment).flatMap(env -> env.getProperty(KestraContext.KESTRA_SERVER_TYPE, ServerType.class)).orElse(ServerType.STANDALONE);
        }

        @Override
        public Optional<Integer> getWorkerMaxNumThreads() {
            return Optional.ofNullable(this.environment).flatMap(env -> env.getProperty(KestraContext.KESTRA_WORKER_MAX_NUM_THREADS, Integer.class));
        }

        @Override
        public Optional<String> getWorkerGroupKey() {
            return Optional.ofNullable(this.environment).flatMap(env -> env.getProperty(KestraContext.KESTRA_WORKER_GROUP_KEY, String.class));
        }

        @Override
        public void injectWorkerConfigs(Integer maxNumThreads, String workerGroupKey) {
            HashMap configs = new HashMap();
            Optional.ofNullable(maxNumThreads).ifPresent(val -> configs.put(KestraContext.KESTRA_WORKER_MAX_NUM_THREADS, val));
            Optional.ofNullable(workerGroupKey).ifPresent(val -> configs.put(KestraContext.KESTRA_WORKER_GROUP_KEY, val));
            if (!configs.isEmpty()) {
                this.environment.addPropertySource(PropertySource.of((String)"kestra-runtime", configs));
            }
        }

        @Override
        public void shutdown() {
            if (this.isShutdown.compareAndSet(false, true)) {
                log.info("Kestra server - Shutdown initiated");
                this.applicationContext.close();
                log.info("Kestra server - Shutdown completed");
            }
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public PluginRegistry getPluginRegistry() {
            return (PluginRegistry)this.applicationContext.getBean(PluginRegistry.class);
        }

        @Override
        public StorageInterface getStorageInterface() {
            return (StorageInterface)this.applicationContext.getBean(StorageInterface.class);
        }
    }
}

