/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.docs;

import io.kestra.core.docs.AbstractClassDocumentation;
import io.kestra.core.docs.JsonSchemaGenerator;
import io.kestra.core.plugins.PluginClassAndMetadata;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public class ClassPluginDocumentation<T>
extends AbstractClassDocumentation<T> {
    private static final Map<PluginDocIdentifier, ClassPluginDocumentation<?>> CACHE = new ConcurrentHashMap();
    private String icon;
    private String group;
    protected String docLicense;
    private String pluginTitle;
    private String subGroup;
    private String replacement;
    private List<MetricDoc> docMetrics;
    private Map<String, Object> outputs = new TreeMap<String, Object>();
    private Map<String, Object> outputsSchema;

    private ClassPluginDocumentation(JsonSchemaGenerator jsonSchemaGenerator, PluginClassAndMetadata<T> plugin, boolean allProperties) {
        super(jsonSchemaGenerator, plugin.type(), allProperties ? null : plugin.baseClass());
        Class<T> cls = plugin.type();
        this.cls = plugin.alias() == null ? cls.getName() : plugin.alias();
        this.group = plugin.group();
        this.docLicense = plugin.license();
        this.pluginTitle = plugin.title();
        this.icon = plugin.icon();
        if (plugin.alias() != null) {
            this.replacement = cls.getName();
        }
        if (this.group != null && cls.getPackageName().startsWith(this.group) && cls.getPackageName().length() > this.group.length() && cls.getPackageName().charAt(this.group.length()) == '.') {
            this.subGroup = cls.getPackageName().substring(this.group.length() + 1);
        }
        this.shortName = plugin.alias() == null ? cls.getSimpleName() : plugin.alias().substring(plugin.alias().lastIndexOf(46) + 1);
        this.outputsSchema = jsonSchemaGenerator.outputs(allProperties ? null : plugin.baseClass(), cls);
        if (this.outputsSchema.containsKey("$defs")) {
            this.defs.putAll((Map)this.outputsSchema.get("$defs"));
            this.outputsSchema.remove("$defs");
        }
        if (this.outputsSchema.containsKey("properties")) {
            this.outputs = ClassPluginDocumentation.flattenWithoutType(ClassPluginDocumentation.properties(this.outputsSchema), ClassPluginDocumentation.required(this.outputsSchema));
        }
        if (this.propertiesSchema.containsKey("$metrics")) {
            List metrics = (List)this.propertiesSchema.get("$metrics");
            this.docMetrics = metrics.stream().map(r -> new MetricDoc((String)r.get("name"), (String)r.get("type"), (String)r.get("unit"), (String)r.get("description"))).toList();
        }
        if (plugin.alias() != null) {
            this.deprecated = true;
        }
    }

    public static <T> ClassPluginDocumentation<T> of(JsonSchemaGenerator jsonSchemaGenerator, PluginClassAndMetadata<T> plugin, String version, boolean allProperties) {
        return CACHE.computeIfAbsent(new PluginDocIdentifier(plugin.type(), version, allProperties), key -> new ClassPluginDocumentation(jsonSchemaGenerator, plugin, allProperties));
    }

    @Generated
    public String getIcon() {
        return this.icon;
    }

    @Generated
    public String getGroup() {
        return this.group;
    }

    @Generated
    public String getDocLicense() {
        return this.docLicense;
    }

    @Generated
    public String getPluginTitle() {
        return this.pluginTitle;
    }

    @Generated
    public String getSubGroup() {
        return this.subGroup;
    }

    @Generated
    public String getReplacement() {
        return this.replacement;
    }

    @Generated
    public List<MetricDoc> getDocMetrics() {
        return this.docMetrics;
    }

    @Generated
    public Map<String, Object> getOutputs() {
        return this.outputs;
    }

    @Generated
    public Map<String, Object> getOutputsSchema() {
        return this.outputsSchema;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassPluginDocumentation)) {
            return false;
        }
        ClassPluginDocumentation other = (ClassPluginDocumentation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$icon = this.getIcon();
        String other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        String this$group = this.getGroup();
        String other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        String this$docLicense = this.getDocLicense();
        String other$docLicense = other.getDocLicense();
        if (this$docLicense == null ? other$docLicense != null : !this$docLicense.equals(other$docLicense)) {
            return false;
        }
        String this$pluginTitle = this.getPluginTitle();
        String other$pluginTitle = other.getPluginTitle();
        if (this$pluginTitle == null ? other$pluginTitle != null : !this$pluginTitle.equals(other$pluginTitle)) {
            return false;
        }
        String this$subGroup = this.getSubGroup();
        String other$subGroup = other.getSubGroup();
        if (this$subGroup == null ? other$subGroup != null : !this$subGroup.equals(other$subGroup)) {
            return false;
        }
        String this$replacement = this.getReplacement();
        String other$replacement = other.getReplacement();
        if (this$replacement == null ? other$replacement != null : !this$replacement.equals(other$replacement)) {
            return false;
        }
        List<MetricDoc> this$docMetrics = this.getDocMetrics();
        List<MetricDoc> other$docMetrics = other.getDocMetrics();
        if (this$docMetrics == null ? other$docMetrics != null : !((Object)this$docMetrics).equals(other$docMetrics)) {
            return false;
        }
        Map<String, Object> this$outputs = this.getOutputs();
        Map<String, Object> other$outputs = other.getOutputs();
        if (this$outputs == null ? other$outputs != null : !((Object)this$outputs).equals(other$outputs)) {
            return false;
        }
        Map<String, Object> this$outputsSchema = this.getOutputsSchema();
        Map<String, Object> other$outputsSchema = other.getOutputsSchema();
        return !(this$outputsSchema == null ? other$outputsSchema != null : !((Object)this$outputsSchema).equals(other$outputsSchema));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClassPluginDocumentation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        String $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        String $docLicense = this.getDocLicense();
        result = result * 59 + ($docLicense == null ? 43 : $docLicense.hashCode());
        String $pluginTitle = this.getPluginTitle();
        result = result * 59 + ($pluginTitle == null ? 43 : $pluginTitle.hashCode());
        String $subGroup = this.getSubGroup();
        result = result * 59 + ($subGroup == null ? 43 : $subGroup.hashCode());
        String $replacement = this.getReplacement();
        result = result * 59 + ($replacement == null ? 43 : $replacement.hashCode());
        List<MetricDoc> $docMetrics = this.getDocMetrics();
        result = result * 59 + ($docMetrics == null ? 43 : ((Object)$docMetrics).hashCode());
        Map<String, Object> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : ((Object)$outputs).hashCode());
        Map<String, Object> $outputsSchema = this.getOutputsSchema();
        result = result * 59 + ($outputsSchema == null ? 43 : ((Object)$outputsSchema).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "ClassPluginDocumentation(super=" + super.toString() + ", icon=" + this.getIcon() + ", group=" + this.getGroup() + ", docLicense=" + this.getDocLicense() + ", pluginTitle=" + this.getPluginTitle() + ", subGroup=" + this.getSubGroup() + ", replacement=" + this.getReplacement() + ", docMetrics=" + String.valueOf(this.getDocMetrics()) + ", outputs=" + String.valueOf(this.getOutputs()) + ", outputsSchema=" + String.valueOf(this.getOutputsSchema()) + ")";
    }

    private record PluginDocIdentifier(String pluginClassAndVersion, boolean allProperties) {
        public PluginDocIdentifier(Class<?> pluginClass, String version, boolean allProperties) {
            this(pluginClass.getName() + ":" + version, allProperties);
        }
    }

    public static class MetricDoc {
        String name;
        String type;
        String unit;
        String description;

        @ConstructorProperties(value={"name", "type", "unit", "description"})
        @Generated
        public MetricDoc(String name, String type, String unit, String description) {
            this.name = name;
            this.type = type;
            this.unit = unit;
            this.description = description;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getUnit() {
            return this.unit;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }
    }
}

