/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.http.client.apache;

import io.kestra.core.http.client.apache.AbstractLoggingInterceptor;
import io.kestra.core.http.client.configurations.HttpConfiguration;
import java.beans.ConstructorProperties;
import java.io.IOException;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.slf4j.Logger;

public class LoggingResponseInterceptor
extends AbstractLoggingInterceptor
implements HttpResponseInterceptor {
    private Logger logger;
    private HttpConfiguration.LoggingType[] logs;

    public void process(HttpResponse response, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        if (this.logger.isDebugEnabled() && ArrayUtils.contains((Object[])this.logs, (Object)((Object)HttpConfiguration.LoggingType.RESPONSE_HEADERS))) {
            this.logger.debug(LoggingResponseInterceptor.buildResponseEntry(response));
            this.logger.debug(LoggingResponseInterceptor.buildHeadersEntry("response", response.getHeaders()));
        }
        if (this.logger.isTraceEnabled() && ArrayUtils.contains((Object[])this.logs, (Object)((Object)HttpConfiguration.LoggingType.RESPONSE_BODY))) {
            ClassicHttpResponse classicHttpResponse;
            this.logger.trace(LoggingResponseInterceptor.buildEntityEntry("response", response instanceof ClassicHttpResponse ? (classicHttpResponse = (ClassicHttpResponse)response) : null));
        }
    }

    private static String buildResponseEntry(HttpResponse response) {
        return "response:\n    reason: " + response.getReasonPhrase();
    }

    @ConstructorProperties(value={"logger", "logs"})
    @Generated
    public LoggingResponseInterceptor(Logger logger, HttpConfiguration.LoggingType[] logs) {
        this.logger = logger;
        this.logs = logs;
    }
}

