/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models;

import io.kestra.core.utils.MapUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotEmpty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@Schema(description="A key/value pair that can be attached to a Flow or Execution. Labels are often used to organize and categorize objects.")
public record Label(@NotEmpty String key, @NotEmpty String value) {
    public static final String SYSTEM_PREFIX = "system.";
    public static final String CORRELATION_ID = "system.correlationId";
    public static final String USERNAME = "system.username";
    public static final String APP = "system.app";
    public static final String READ_ONLY = "system.readOnly";
    public static final String RESTARTED = "system.restarted";
    public static final String REPLAY = "system.replay";
    public static final String REPLAYED = "system.replayed";
    public static final String SIMULATED_EXECUTION = "system.simulatedExecution";
    public static final String TEST = "system.test";

    public static Map<String, Object> toNestedMap(List<Label> labels) {
        return MapUtils.flattenToNestedMap(Label.toMap(labels));
    }

    public static Map<String, String> toMap(@Nullable List<Label> labels) {
        if (labels == null || labels.isEmpty()) {
            return Collections.emptyMap();
        }
        return labels.stream().filter(label -> label.value() != null && !label.value().isEmpty() && label.key() != null && !label.key().isEmpty()).collect(Collectors.toMap(Label::key, Label::value, (first, second) -> second, LinkedHashMap::new));
    }

    public static List<Label> deduplicate(@Nullable List<Label> labels) {
        if (labels == null || labels.isEmpty()) {
            return Collections.emptyList();
        }
        return Label.toMap(labels).entrySet().stream().filter(Label.getEntryNotEmptyPredicate()).map(entry -> new Label((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toCollection(ArrayList::new));
    }

    public static List<Label> from(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return List.of();
        }
        return map.entrySet().stream().filter(Label.getEntryNotEmptyPredicate()).map(entry -> new Label((String)entry.getKey(), (String)entry.getValue())).toList();
    }

    public static Map<String, String> from(String label) {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] keyValueArray = label.split(":");
        if (keyValueArray.length == 2) {
            map.put(keyValueArray[0], keyValueArray[1]);
        }
        return map;
    }

    public static Predicate<Map.Entry<String, String>> getEntryNotEmptyPredicate() {
        return entry -> entry.getKey() != null && !((String)entry.getKey()).isEmpty() && entry.getValue() != null && !((String)entry.getValue()).isEmpty();
    }
}

