/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.kestra.core.models.flows.AbstractFlow;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.runners.TaskRunner;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.repositories.FlowRepositoryInterface;
import io.micronaut.core.annotation.Introspected;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

@Introspected
@JsonDeserialize(builder=FlowUsageBuilderImpl.class)
public class FlowUsage {
    private static final String TUTORIAL_NAMESPACE = "tutorial";
    private final Integer count;
    private final Long namespacesCount;
    private final Map<String, Long> taskTypeCount;
    private final Map<String, Long> triggerTypeCount;
    private final Map<String, Long> taskRunnerTypeCount;

    public static FlowUsage of(String tenantId, FlowRepositoryInterface flowRepository) {
        return FlowUsage.of(flowRepository.findAll(tenantId));
    }

    public static FlowUsage of(FlowRepositoryInterface flowRepository) {
        return FlowUsage.of(flowRepository.findAllForAllTenants());
    }

    public static FlowUsage of(List<Flow> flows) {
        List<Flow> filtered = flows.stream().filter(flow -> !TUTORIAL_NAMESPACE.equals(flow.getNamespace())).toList();
        return ((FlowUsageBuilder)((FlowUsageBuilder)((FlowUsageBuilder)((FlowUsageBuilder)((FlowUsageBuilder)FlowUsage.builder().count(FlowUsage.count(filtered))).namespacesCount(FlowUsage.namespacesCount(filtered))).taskTypeCount(FlowUsage.taskTypeCount(filtered))).triggerTypeCount(FlowUsage.triggerTypeCount(filtered))).taskRunnerTypeCount(FlowUsage.taskRunnerTypeCount(filtered))).build();
    }

    protected static int count(List<Flow> allFlows) {
        return allFlows.size();
    }

    protected static long namespacesCount(List<Flow> allFlows) {
        return allFlows.stream().map(AbstractFlow::getNamespace).distinct().count();
    }

    protected static Map<String, Long> taskTypeCount(List<Flow> allFlows) {
        return allFlows.stream().flatMap(f -> f.allTasks().map(Task::getType)).collect(Collectors.groupingBy(f -> f, Collectors.counting()));
    }

    protected static Map<String, Long> triggerTypeCount(List<Flow> allFlows) {
        return allFlows.stream().flatMap(f -> f.getTriggers() != null ? f.getTriggers().stream().map(AbstractTrigger::getType) : Stream.empty()).collect(Collectors.groupingBy(f -> f, Collectors.counting()));
    }

    protected static Map<String, Long> taskRunnerTypeCount(List<Flow> allFlows) {
        return allFlows.stream().flatMap(Flow::allTasks).filter(t -> {
            try {
                return t.getClass().getMethod("getTaskRunner", new Class[0]) != null;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }).map(t -> {
            try {
                TaskRunner taskRunner = (TaskRunner)t.getClass().getMethod("getTaskRunner", new Class[0]).invoke(t, new Object[0]);
                return taskRunner != null ? taskRunner.getType() : null;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.groupingBy(f -> f, Collectors.counting()));
    }

    @Generated
    protected FlowUsage(FlowUsageBuilder<?, ?> b) {
        this.count = b.count;
        this.namespacesCount = b.namespacesCount;
        this.taskTypeCount = b.taskTypeCount;
        this.triggerTypeCount = b.triggerTypeCount;
        this.taskRunnerTypeCount = b.taskRunnerTypeCount;
    }

    @Generated
    public static FlowUsageBuilder<?, ?> builder() {
        return new FlowUsageBuilderImpl();
    }

    @Generated
    public Integer getCount() {
        return this.count;
    }

    @Generated
    public Long getNamespacesCount() {
        return this.namespacesCount;
    }

    @Generated
    public Map<String, Long> getTaskTypeCount() {
        return this.taskTypeCount;
    }

    @Generated
    public Map<String, Long> getTriggerTypeCount() {
        return this.triggerTypeCount;
    }

    @Generated
    public Map<String, Long> getTaskRunnerTypeCount() {
        return this.taskRunnerTypeCount;
    }

    @Generated
    public static abstract class FlowUsageBuilder<C extends FlowUsage, B extends FlowUsageBuilder<C, B>> {
        @Generated
        private Integer count;
        @Generated
        private Long namespacesCount;
        @Generated
        private Map<String, Long> taskTypeCount;
        @Generated
        private Map<String, Long> triggerTypeCount;
        @Generated
        private Map<String, Long> taskRunnerTypeCount;

        @Generated
        public B count(Integer count) {
            this.count = count;
            return this.self();
        }

        @Generated
        public B namespacesCount(Long namespacesCount) {
            this.namespacesCount = namespacesCount;
            return this.self();
        }

        @Generated
        public B taskTypeCount(Map<String, Long> taskTypeCount) {
            this.taskTypeCount = taskTypeCount;
            return this.self();
        }

        @Generated
        public B triggerTypeCount(Map<String, Long> triggerTypeCount) {
            this.triggerTypeCount = triggerTypeCount;
            return this.self();
        }

        @Generated
        public B taskRunnerTypeCount(Map<String, Long> taskRunnerTypeCount) {
            this.taskRunnerTypeCount = taskRunnerTypeCount;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "FlowUsage.FlowUsageBuilder(count=" + this.count + ", namespacesCount=" + this.namespacesCount + ", taskTypeCount=" + String.valueOf(this.taskTypeCount) + ", triggerTypeCount=" + String.valueOf(this.triggerTypeCount) + ", taskRunnerTypeCount=" + String.valueOf(this.taskRunnerTypeCount) + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class FlowUsageBuilderImpl
    extends FlowUsageBuilder<FlowUsage, FlowUsageBuilderImpl> {
        @Generated
        private FlowUsageBuilderImpl() {
        }

        @Override
        @Generated
        protected FlowUsageBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public FlowUsage build() {
            return new FlowUsage(this);
        }
    }
}

