/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.flows;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.kestra.core.models.Label;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.Input;
import io.kestra.core.models.flows.Output;
import io.kestra.core.models.tasks.WorkerGroup;
import io.kestra.core.serializers.ListOrMapOfLabelDeserializer;
import io.kestra.core.serializers.ListOrMapOfLabelSerializer;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonDeserialize
public abstract class AbstractFlow
implements FlowInterface {
    @NotNull
    @NotBlank
    @Pattern(regexp="^[a-zA-Z0-9][a-zA-Z0-9._-]*")
    @Size(min=1, max=100)
    @NotNull @NotBlank @Pattern(regexp="^[a-zA-Z0-9][a-zA-Z0-9._-]*") @Size(min=1, max=100) String id;
    @NotNull
    @Pattern(regexp="^[a-z0-9][a-z0-9._-]*")
    @Size(min=1, max=150)
    @NotNull @Pattern(regexp="^[a-z0-9][a-z0-9._-]*") @Size(min=1, max=150) String namespace;
    @Min(value=1L)
    @Min(value=1L) Integer revision;
    String description;
    @Valid
    List<Input<?>> inputs;
    @Valid
    List<Output> outputs;
    @NotNull
    boolean disabled;
    @NotNull
    boolean deleted;
    @Hidden
    @Pattern(regexp="^[a-z0-9][a-z0-9_-]*")
    @Pattern(regexp="^[a-z0-9][a-z0-9_-]*") String tenantId;
    @JsonSerialize(using=ListOrMapOfLabelSerializer.class)
    @JsonDeserialize(using=ListOrMapOfLabelDeserializer.class)
    @Schema(description="Labels as a list of Label (key/value pairs) or as a map of string to string.", oneOf={Label[].class, Map.class})
    @Valid
    List<Label> labels;
    @Schema(type="object", additionalProperties=Schema.AdditionalPropertiesValue.FALSE)
    Map<String, Object> variables;
    @Valid
    private WorkerGroup workerGroup;

    @Generated
    private static boolean $default$disabled() {
        return false;
    }

    @Generated
    private static boolean $default$deleted() {
        return false;
    }

    @Generated
    protected AbstractFlow(AbstractFlowBuilder<?, ?> b) {
        this.id = b.id;
        this.namespace = b.namespace;
        this.revision = b.revision;
        this.description = b.description;
        this.inputs = b.inputs;
        this.outputs = b.outputs;
        this.disabled = b.disabled$set ? b.disabled$value : AbstractFlow.$default$disabled();
        this.deleted = b.deleted$set ? b.deleted$value : AbstractFlow.$default$deleted();
        this.tenantId = b.tenantId;
        this.labels = b.labels;
        this.variables = b.variables;
        this.workerGroup = b.workerGroup;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    @Generated
    public Integer getRevision() {
        return this.revision;
    }

    @Override
    @Generated
    public String getDescription() {
        return this.description;
    }

    @Override
    @Generated
    public List<Input<?>> getInputs() {
        return this.inputs;
    }

    @Override
    @Generated
    public List<Output> getOutputs() {
        return this.outputs;
    }

    @Override
    @Generated
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    @Generated
    public List<Label> getLabels() {
        return this.labels;
    }

    @Override
    @Generated
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    @Override
    @Generated
    public WorkerGroup getWorkerGroup() {
        return this.workerGroup;
    }

    @Generated
    public AbstractFlow() {
        this.disabled = AbstractFlow.$default$disabled();
        this.deleted = AbstractFlow.$default$deleted();
    }

    @Override
    @Generated
    public boolean isDeleted() {
        return this.deleted;
    }

    @Generated
    public static abstract class AbstractFlowBuilder<C extends AbstractFlow, B extends AbstractFlowBuilder<C, B>> {
        @Generated
        private String id;
        @Generated
        private String namespace;
        @Generated
        private Integer revision;
        @Generated
        private String description;
        @Generated
        private List<Input<?>> inputs;
        @Generated
        private List<Output> outputs;
        @Generated
        private boolean disabled$set;
        @Generated
        private boolean disabled$value;
        @Generated
        private boolean deleted$set;
        @Generated
        private boolean deleted$value;
        @Generated
        private String tenantId;
        @Generated
        private List<Label> labels;
        @Generated
        private Map<String, Object> variables;
        @Generated
        private WorkerGroup workerGroup;

        @Generated
        protected B $fillValuesFrom(C instance) {
            AbstractFlowBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AbstractFlow instance, AbstractFlowBuilder<?, ?> b) {
            b.id(instance.id);
            b.namespace(instance.namespace);
            b.revision(instance.revision);
            b.description(instance.description);
            b.inputs(instance.inputs);
            b.outputs(instance.outputs);
            b.disabled(instance.disabled);
            b.deleted(instance.deleted);
            b.tenantId(instance.tenantId);
            b.labels(instance.labels);
            b.variables(instance.variables);
            b.workerGroup(instance.workerGroup);
        }

        @Generated
        public B id(String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B namespace(String namespace) {
            this.namespace = namespace;
            return this.self();
        }

        @Generated
        public B revision(Integer revision) {
            this.revision = revision;
            return this.self();
        }

        @Generated
        public B description(String description) {
            this.description = description;
            return this.self();
        }

        @Generated
        public B inputs(List<Input<?>> inputs) {
            this.inputs = inputs;
            return this.self();
        }

        @Generated
        public B outputs(List<Output> outputs) {
            this.outputs = outputs;
            return this.self();
        }

        @Generated
        public B disabled(boolean disabled) {
            this.disabled$value = disabled;
            this.disabled$set = true;
            return this.self();
        }

        @Generated
        public B deleted(boolean deleted) {
            this.deleted$value = deleted;
            this.deleted$set = true;
            return this.self();
        }

        @Generated
        public B tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this.self();
        }

        @JsonDeserialize(using=ListOrMapOfLabelDeserializer.class)
        @Generated
        public B labels(List<Label> labels) {
            this.labels = labels;
            return this.self();
        }

        @Generated
        public B variables(Map<String, Object> variables) {
            this.variables = variables;
            return this.self();
        }

        @Generated
        public B workerGroup(WorkerGroup workerGroup) {
            this.workerGroup = workerGroup;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "AbstractFlow.AbstractFlowBuilder(id=" + this.id + ", namespace=" + this.namespace + ", revision=" + this.revision + ", description=" + this.description + ", inputs=" + String.valueOf(this.inputs) + ", outputs=" + String.valueOf(this.outputs) + ", disabled$value=" + this.disabled$value + ", deleted$value=" + this.deleted$value + ", tenantId=" + this.tenantId + ", labels=" + String.valueOf(this.labels) + ", variables=" + String.valueOf(this.variables) + ", workerGroup=" + String.valueOf(this.workerGroup) + ")";
        }
    }
}

