/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.flows;

import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.validations.FlowValidation;
import io.micronaut.core.annotation.Introspected;
import jakarta.annotation.Nullable;
import lombok.Generated;

@Introspected
@FlowValidation
public class FlowWithPath {
    private FlowInterface flow;
    @Nullable
    private String tenantId;
    private String id;
    private String namespace;
    private String path;

    public static FlowWithPath of(FlowInterface flow, String path) {
        return ((FlowWithPathBuilder)((FlowWithPathBuilder)((FlowWithPathBuilder)((FlowWithPathBuilder)FlowWithPath.builder().tenantId(flow.getTenantId())).id(flow.getId())).namespace(flow.getNamespace())).path(path)).build();
    }

    public String uidWithoutRevision() {
        return IdUtils.fromParts(this.tenantId, this.namespace, this.id);
    }

    @Generated
    protected FlowWithPath(FlowWithPathBuilder<?, ?> b) {
        this.flow = b.flow;
        this.tenantId = b.tenantId;
        this.id = b.id;
        this.namespace = b.namespace;
        this.path = b.path;
    }

    @Generated
    public static FlowWithPathBuilder<?, ?> builder() {
        return new FlowWithPathBuilderImpl();
    }

    @Generated
    public FlowWithPathBuilder<?, ?> toBuilder() {
        return new FlowWithPathBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public FlowInterface getFlow() {
        return this.flow;
    }

    @Nullable
    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public FlowWithPath() {
    }

    @Generated
    public String toString() {
        return "FlowWithPath(flow=" + String.valueOf(this.getFlow()) + ", tenantId=" + this.getTenantId() + ", id=" + this.getId() + ", namespace=" + this.getNamespace() + ", path=" + this.getPath() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowWithPath)) {
            return false;
        }
        FlowWithPath other = (FlowWithPath)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FlowInterface this$flow = this.getFlow();
        FlowInterface other$flow = other.getFlow();
        if (this$flow == null ? other$flow != null : !this$flow.equals(other$flow)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        return !(this$path == null ? other$path != null : !this$path.equals(other$path));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FlowWithPath;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FlowInterface $flow = this.getFlow();
        result = result * 59 + ($flow == null ? 43 : $flow.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        return result;
    }

    @Generated
    public static abstract class FlowWithPathBuilder<C extends FlowWithPath, B extends FlowWithPathBuilder<C, B>> {
        @Generated
        private FlowInterface flow;
        @Generated
        private String tenantId;
        @Generated
        private String id;
        @Generated
        private String namespace;
        @Generated
        private String path;

        @Generated
        protected B $fillValuesFrom(C instance) {
            FlowWithPathBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(FlowWithPath instance, FlowWithPathBuilder<?, ?> b) {
            b.flow(instance.flow);
            b.tenantId(instance.tenantId);
            b.id(instance.id);
            b.namespace(instance.namespace);
            b.path(instance.path);
        }

        @Generated
        public B flow(FlowInterface flow) {
            this.flow = flow;
            return this.self();
        }

        @Generated
        public B tenantId(@Nullable String tenantId) {
            this.tenantId = tenantId;
            return this.self();
        }

        @Generated
        public B id(String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B namespace(String namespace) {
            this.namespace = namespace;
            return this.self();
        }

        @Generated
        public B path(String path) {
            this.path = path;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "FlowWithPath.FlowWithPathBuilder(flow=" + String.valueOf(this.flow) + ", tenantId=" + this.tenantId + ", id=" + this.id + ", namespace=" + this.namespace + ", path=" + this.path + ")";
        }
    }

    @Generated
    private static final class FlowWithPathBuilderImpl
    extends FlowWithPathBuilder<FlowWithPath, FlowWithPathBuilderImpl> {
        @Generated
        private FlowWithPathBuilderImpl() {
        }

        @Override
        @Generated
        protected FlowWithPathBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public FlowWithPath build() {
            return new FlowWithPath(this);
        }
    }
}

