/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.flows.input;

import io.kestra.core.models.flows.Input;
import io.kestra.core.validations.FileInputValidation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.constraints.NotNull;
import java.net.URI;
import java.util.List;
import java.util.Set;
import lombok.Generated;

@FileInputValidation
public class FileInput
extends Input<URI> {
    private static final String DEFAULT_EXTENSION = ".upl";
    @Deprecated(since="0.24", forRemoval=true)
    public String extension;
    private List<String> allowedFileExtensions;

    private String getFileExtension(URI uri) {
        String path = uri.getPath();
        int lastDotIndex = path.lastIndexOf(".");
        return lastDotIndex >= 0 ? path.substring(lastDotIndex).toLowerCase() : "";
    }

    @Override
    public void validate(URI input) throws ConstraintViolationException {
        if (input == null || this.allowedFileExtensions == null || this.allowedFileExtensions.isEmpty()) {
            return;
        }
        String extension = this.getFileExtension(input);
        if (!this.allowedFileExtensions.contains(extension.toLowerCase())) {
            throw new ConstraintViolationException("File type not allowed. Accepted extensions: " + String.join((CharSequence)", ", this.allowedFileExtensions), Set.of());
        }
    }

    public static String findFileInputExtension(@NotNull List<Input<?>> inputs, @NotNull String fileName) {
        String res = inputs.stream().filter(in -> in instanceof FileInput).filter(in -> in.getId().equals(fileName)).filter(flowInput -> ((FileInput)flowInput).getExtension() != null).map(flowInput -> ((FileInput)flowInput).getExtension()).findFirst().orElse(DEFAULT_EXTENSION);
        return res.startsWith(".") ? res : "." + res;
    }

    @Generated
    protected FileInput(FileInputBuilder<?, ?> b) {
        super(b);
        this.extension = b.extension;
        this.allowedFileExtensions = b.allowedFileExtensions;
    }

    @Generated
    public static FileInputBuilder<?, ?> builder() {
        return new FileInputBuilderImpl();
    }

    @Deprecated
    @Generated
    public String getExtension() {
        return this.extension;
    }

    @Generated
    public List<String> getAllowedFileExtensions() {
        return this.allowedFileExtensions;
    }

    @Generated
    public FileInput() {
    }

    @Generated
    public static abstract class FileInputBuilder<C extends FileInput, B extends FileInputBuilder<C, B>>
    extends Input.InputBuilder<URI, C, B> {
        @Generated
        private String extension;
        @Generated
        private List<String> allowedFileExtensions;

        @Deprecated
        @Generated
        public B extension(String extension) {
            this.extension = extension;
            return (B)this.self();
        }

        @Generated
        public B allowedFileExtensions(List<String> allowedFileExtensions) {
            this.allowedFileExtensions = allowedFileExtensions;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "FileInput.FileInputBuilder(super=" + super.toString() + ", extension=" + this.extension + ", allowedFileExtensions=" + String.valueOf(this.allowedFileExtensions) + ")";
        }
    }

    @Generated
    private static final class FileInputBuilderImpl
    extends FileInputBuilder<FileInput, FileInputBuilderImpl> {
        @Generated
        private FileInputBuilderImpl() {
        }

        @Override
        @Generated
        protected FileInputBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public FileInput build() {
            return new FileInput(this);
        }
    }
}

