/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.flows.sla.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.sla.ExecutionChangedSLA;
import io.kestra.core.models.flows.sla.SLA;
import io.kestra.core.models.flows.sla.Violation;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.TruthUtils;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.Optional;
import lombok.Generated;

public class ExecutionAssertionSLA
extends SLA
implements ExecutionChangedSLA {
    @NotNull
    @NotEmpty
    @JsonProperty(value="assert")
    private String _assert;

    @Override
    public Optional<Violation> evaluate(RunContext runContext, Execution execution) throws InternalException {
        String result = runContext.render(this.get_assert());
        if (!TruthUtils.isTruthy(result)) {
            String reason = "assertion is false: " + this.get_assert() + ".";
            return Optional.of(new Violation(this.getId(), this.getBehavior(), this.getLabels(), reason));
        }
        return Optional.empty();
    }

    @Generated
    protected ExecutionAssertionSLA(ExecutionAssertionSLABuilder<?, ?> b) {
        super(b);
        this._assert = b._assert;
    }

    @Generated
    public static ExecutionAssertionSLABuilder<?, ?> builder() {
        return new ExecutionAssertionSLABuilderImpl();
    }

    @Generated
    public String get_assert() {
        return this._assert;
    }

    @Generated
    public ExecutionAssertionSLA() {
    }

    @Generated
    public static abstract class ExecutionAssertionSLABuilder<C extends ExecutionAssertionSLA, B extends ExecutionAssertionSLABuilder<C, B>>
    extends SLA.SLABuilder<C, B> {
        @Generated
        private String _assert;

        @JsonProperty(value="assert")
        @Generated
        public B _assert(String _assert) {
            this._assert = _assert;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ExecutionAssertionSLA.ExecutionAssertionSLABuilder(super=" + super.toString() + ", _assert=" + this._assert + ")";
        }
    }

    @Generated
    private static final class ExecutionAssertionSLABuilderImpl
    extends ExecutionAssertionSLABuilder<ExecutionAssertionSLA, ExecutionAssertionSLABuilderImpl> {
        @Generated
        private ExecutionAssertionSLABuilderImpl() {
        }

        @Override
        @Generated
        protected ExecutionAssertionSLABuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ExecutionAssertionSLA build() {
            return new ExecutionAssertionSLA(this);
        }
    }
}

