/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.hierarchies;

import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.hierarchies.AbstractGraph;
import io.kestra.core.models.hierarchies.RelationType;
import io.kestra.core.models.tasks.TaskForExecution;
import io.kestra.core.models.tasks.TaskInterface;
import io.micronaut.core.annotation.Introspected;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

@Introspected
public abstract class AbstractGraphTask
extends AbstractGraph {
    private TaskInterface task;
    private final TaskRun taskRun;
    private final List<String> values;
    private final RelationType relationType;

    public AbstractGraphTask(String uid, TaskInterface task, TaskRun taskRun, List<String> values, RelationType relationType) {
        super(uid);
        this.task = task;
        this.taskRun = taskRun;
        this.values = values;
        this.relationType = relationType;
    }

    public AbstractGraphTask(TaskInterface task, TaskRun taskRun, List<String> values, RelationType relationType) {
        this(task.getId(), task, taskRun, values, relationType);
    }

    @Override
    public String getLabel() {
        String[] splitUid = this.getUid().split("\\.");
        return splitUid[splitUid.length - 1] + (String)(this.getTaskRun() != null ? " > " + this.getTaskRun().getValue() + " (" + this.getTaskRun().getId() + ")" : "");
    }

    @Override
    public String getUid() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.uid);
        if (this.values != null) {
            list.addAll(this.values);
        }
        return String.join((CharSequence)"_", list);
    }

    @Override
    public AbstractGraph forExecution() {
        this.setTask(TaskForExecution.of(this.getTask()));
        return this;
    }

    @Override
    @Generated
    public String toString() {
        return "AbstractGraphTask(super=" + super.toString() + ", task=" + String.valueOf(this.getTask()) + ", taskRun=" + String.valueOf(this.getTaskRun()) + ", values=" + String.valueOf(this.getValues()) + ", relationType=" + String.valueOf((Object)this.getRelationType()) + ")";
    }

    @Generated
    public TaskInterface getTask() {
        return this.task;
    }

    @Generated
    public TaskRun getTaskRun() {
        return this.taskRun;
    }

    @Generated
    public List<String> getValues() {
        return this.values;
    }

    @Generated
    public RelationType getRelationType() {
        return this.relationType;
    }

    @Generated
    public void setTask(TaskInterface task) {
        this.task = task;
    }
}

