/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.hierarchies;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.hierarchies.AbstractGraphTask;
import io.kestra.core.models.hierarchies.RelationType;
import io.kestra.core.models.tasks.ExecutableTask;
import io.kestra.core.models.tasks.Output;
import io.kestra.core.models.tasks.TaskInterface;
import io.kestra.core.runners.FlowMetaStoreInterface;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.SubflowExecution;
import io.kestra.core.runners.SubflowExecutionResult;
import java.util.List;
import java.util.Optional;

public class SubflowGraphTask
extends AbstractGraphTask {
    public SubflowGraphTask(String uid, ExecutableTask<?> task, TaskRun taskRun, List<String> values, RelationType relationType) {
        super(uid, (TaskInterface)((Object)task), taskRun, values, relationType);
    }

    public SubflowGraphTask(ExecutableTask<?> task, TaskRun taskRun, List<String> values, RelationType relationType) {
        super((TaskInterface)((Object)task), taskRun, values, relationType);
    }

    public ExecutableTask<?> executableTask() {
        TaskInterface task = super.getTask();
        if (task instanceof ExecutableTask) {
            ExecutableTask executableTask = (ExecutableTask)((Object)task);
            return executableTask;
        }
        return null;
    }

    public SubflowGraphTask withRenderedSubflowId(RunContext runContext) {
        final SubflowGraphTask previous = this;
        return new SubflowGraphTask(this, this.getUid(), new SubflowTaskWrapper(runContext, this.executableTask()), this.getTaskRun(), this.getValues(), this.getRelationType()){

            public int hashCode() {
                return previous.hashCode();
            }
        };
    }

    public record SubflowTaskWrapper<T extends Output>(RunContext runContext, ExecutableTask<T> subflowTask) implements TaskInterface,
    ExecutableTask<T>
    {
        @Override
        public List<SubflowExecution<?>> createSubflowExecutions(RunContext runContext, FlowMetaStoreInterface flowExecutorInterface, Flow currentFlow, Execution currentExecution, TaskRun currentTaskRun) throws InternalException {
            return this.subflowTask.createSubflowExecutions(runContext, flowExecutorInterface, currentFlow, currentExecution, currentTaskRun);
        }

        @Override
        public Optional<SubflowExecutionResult> createSubflowExecutionResult(RunContext runContext, TaskRun taskRun, FlowInterface flow, Execution execution) {
            return this.subflowTask.createSubflowExecutionResult(runContext, taskRun, flow, execution);
        }

        @Override
        public boolean waitForExecution() {
            return this.subflowTask.waitForExecution();
        }

        @Override
        public ExecutableTask.SubflowId subflowId() {
            String namespace = this.subflowTask.subflowId().namespace();
            String flowId = this.subflowTask.subflowId().flowId();
            if (this.runContext != null) {
                try {
                    namespace = this.runContext.render(namespace);
                    flowId = this.runContext.render(flowId);
                }
                catch (IllegalVariableEvaluationException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            return new ExecutableTask.SubflowId(namespace, flowId, this.subflowTask.subflowId().revision());
        }

        @Override
        public ExecutableTask.RestartBehavior getRestartBehavior() {
            return this.subflowTask.getRestartBehavior();
        }

        @Override
        public String getId() {
            return ((TaskInterface)((Object)this.subflowTask)).getId();
        }

        @Override
        public String getType() {
            return ((TaskInterface)((Object)this.subflowTask)).getType();
        }

        @Override
        public String getVersion() {
            return ((TaskInterface)((Object)this.subflowTask)).getVersion();
        }
    }
}

