/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.kv;

import io.kestra.core.models.DeletedInterface;
import io.kestra.core.models.HasUID;
import io.kestra.core.models.TenantInterface;
import io.kestra.core.storages.kv.KVEntry;
import io.kestra.core.utils.IdUtils;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistedKvMetadata
implements DeletedInterface,
TenantInterface,
HasUID {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PersistedKvMetadata.class);
    @Hidden
    @Pattern(regexp="^[a-z0-9][a-z0-9_-]*")
    private final @Pattern(regexp="^[a-z0-9][a-z0-9_-]*") String tenantId;
    @NotNull
    private final String namespace;
    @NotNull
    private final String name;
    private final String description;
    @NotNull
    private final Integer version;
    private final boolean last;
    @Nullable
    private final Instant expirationDate;
    @Nullable
    private final Instant created;
    @Nullable
    private final Instant updated;
    private final boolean deleted;

    public static PersistedKvMetadata from(String tenantId, KVEntry kvEntry) {
        return PersistedKvMetadata.builder().tenantId(tenantId).namespace(kvEntry.namespace()).name(kvEntry.key()).version(kvEntry.version()).description(kvEntry.description()).created(kvEntry.creationDate()).updated(kvEntry.updateDate()).expirationDate(kvEntry.expirationDate()).build();
    }

    public PersistedKvMetadata asLast() {
        Instant saveDate = Instant.now();
        return this.toBuilder().created(Optional.ofNullable(this.created).orElse(saveDate)).updated(saveDate).last(true).build();
    }

    @Override
    public String uid() {
        return IdUtils.fromParts(this.getTenantId(), this.getNamespace(), this.getName(), this.getVersion().toString());
    }

    @Generated
    private static boolean $default$last() {
        return true;
    }

    @Generated
    public static PersistedKvMetadataBuilder builder() {
        return new PersistedKvMetadataBuilder();
    }

    @Generated
    public PersistedKvMetadataBuilder toBuilder() {
        return new PersistedKvMetadataBuilder().tenantId(this.tenantId).namespace(this.namespace).name(this.name).description(this.description).version(this.version).last(this.last).expirationDate(this.expirationDate).created(this.created).updated(this.updated).deleted(this.deleted);
    }

    @Override
    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Integer getVersion() {
        return this.version;
    }

    @Generated
    public boolean isLast() {
        return this.last;
    }

    @Nullable
    @Generated
    public Instant getExpirationDate() {
        return this.expirationDate;
    }

    @Nullable
    @Generated
    public Instant getCreated() {
        return this.created;
    }

    @Nullable
    @Generated
    public Instant getUpdated() {
        return this.updated;
    }

    @Override
    @Generated
    public boolean isDeleted() {
        return this.deleted;
    }

    @ConstructorProperties(value={"tenantId", "namespace", "name", "description", "version", "last", "expirationDate", "created", "updated", "deleted"})
    @Generated
    public PersistedKvMetadata(String tenantId, String namespace, String name, String description, Integer version, boolean last, @Nullable Instant expirationDate, @Nullable Instant created, @Nullable Instant updated, boolean deleted) {
        this.tenantId = tenantId;
        this.namespace = namespace;
        this.name = name;
        this.description = description;
        this.version = version;
        this.last = last;
        this.expirationDate = expirationDate;
        this.created = created;
        this.updated = updated;
        this.deleted = deleted;
    }

    @Generated
    public String toString() {
        return "PersistedKvMetadata(tenantId=" + this.getTenantId() + ", namespace=" + this.getNamespace() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", version=" + this.getVersion() + ", last=" + this.isLast() + ", expirationDate=" + String.valueOf(this.getExpirationDate()) + ", created=" + String.valueOf(this.getCreated()) + ", updated=" + String.valueOf(this.getUpdated()) + ", deleted=" + this.isDeleted() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PersistedKvMetadata)) {
            return false;
        }
        PersistedKvMetadata other = (PersistedKvMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isLast() != other.isLast()) {
            return false;
        }
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Instant this$expirationDate = this.getExpirationDate();
        Instant other$expirationDate = other.getExpirationDate();
        if (this$expirationDate == null ? other$expirationDate != null : !((Object)this$expirationDate).equals(other$expirationDate)) {
            return false;
        }
        Instant this$created = this.getCreated();
        Instant other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Instant this$updated = this.getUpdated();
        Instant other$updated = other.getUpdated();
        return !(this$updated == null ? other$updated != null : !((Object)this$updated).equals(other$updated));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PersistedKvMetadata;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isLast() ? 79 : 97);
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Instant $expirationDate = this.getExpirationDate();
        result = result * 59 + ($expirationDate == null ? 43 : ((Object)$expirationDate).hashCode());
        Instant $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Instant $updated = this.getUpdated();
        result = result * 59 + ($updated == null ? 43 : ((Object)$updated).hashCode());
        return result;
    }

    @Generated
    public PersistedKvMetadata withTenantId(String tenantId) {
        return this.tenantId == tenantId ? this : new PersistedKvMetadata(tenantId, this.namespace, this.name, this.description, this.version, this.last, this.expirationDate, this.created, this.updated, this.deleted);
    }

    @Generated
    public static class PersistedKvMetadataBuilder {
        @Generated
        private String tenantId;
        @Generated
        private String namespace;
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private Integer version;
        @Generated
        private boolean last$set;
        @Generated
        private boolean last$value;
        @Generated
        private Instant expirationDate;
        @Generated
        private Instant created;
        @Generated
        private Instant updated;
        @Generated
        private boolean deleted;

        @Generated
        PersistedKvMetadataBuilder() {
        }

        @Generated
        public PersistedKvMetadataBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public PersistedKvMetadataBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Generated
        public PersistedKvMetadataBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public PersistedKvMetadataBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public PersistedKvMetadataBuilder version(Integer version) {
            this.version = version;
            return this;
        }

        @Generated
        public PersistedKvMetadataBuilder last(boolean last) {
            this.last$value = last;
            this.last$set = true;
            return this;
        }

        @Generated
        public PersistedKvMetadataBuilder expirationDate(@Nullable Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        @Generated
        public PersistedKvMetadataBuilder created(@Nullable Instant created) {
            this.created = created;
            return this;
        }

        @Generated
        public PersistedKvMetadataBuilder updated(@Nullable Instant updated) {
            this.updated = updated;
            return this;
        }

        @Generated
        public PersistedKvMetadataBuilder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        @Generated
        public PersistedKvMetadata build() {
            boolean last$value = this.last$value;
            if (!this.last$set) {
                last$value = PersistedKvMetadata.$default$last();
            }
            return new PersistedKvMetadata(this.tenantId, this.namespace, this.name, this.description, this.version, last$value, this.expirationDate, this.created, this.updated, this.deleted);
        }

        @Generated
        public String toString() {
            return "PersistedKvMetadata.PersistedKvMetadataBuilder(tenantId=" + this.tenantId + ", namespace=" + this.namespace + ", name=" + this.name + ", description=" + this.description + ", version=" + this.version + ", last$value=" + this.last$value + ", expirationDate=" + String.valueOf(this.expirationDate) + ", created=" + String.valueOf(this.created) + ", updated=" + String.valueOf(this.updated) + ", deleted=" + this.deleted + ")";
        }
    }
}

