/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.tasks;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.FileExistComportment;
import io.micronaut.core.annotation.Introspected;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;

@Introspected
@JsonDeserialize(builder=NamespaceFilesBuilder.class)
public class NamespaceFiles {
    @Schema(title="Whether to enable namespace files to be loaded into the working directory. If explicitly set to `true` in a task, it will load all [Namespace Files](https://kestra.io/docs/developer-guide/namespace-files) into the task's working directory. Note that this property is by default set to `true` so that you can specify only the `include` and `exclude` properties to filter the files to load without having to explicitly set `enabled` to `true`.")
    private Property<Boolean> enabled;
    @Schema(title="A list of filters to include only matching glob patterns. This allows you to only load a subset of the [Namespace Files](https://kestra.io/docs/developer-guide/namespace-files) into the working directory.")
    @Valid
    private Property<List<String>> include;
    @Schema(title="A list of filters to exclude matching glob patterns. This allows you to exclude a subset of the [Namespace Files](https://kestra.io/docs/developer-guide/namespace-files) from being downloaded at runtime. You can combine this property together with `include` to only inject a subset of files that you need into the task's working directory.")
    @Valid
    private Property<List<String>> exclude;
    @Schema(title="A list of namespaces in which searching files. The files are loaded in the namespace order, and only the latest version of a file is kept. Meaning if a file is present in the first and second namespace, only the file present on the second namespace will be loaded.")
    private Property<List<String>> namespaces;
    @Schema(title="Comportment of the task if a file already exist in the working directory.")
    private Property<FileExistComportment> ifExists;
    @Schema(title="Whether to mount file into the root of the working directory, or create a folder per namespace")
    private Property<Boolean> folderPerNamespace;

    @Generated
    private static Property<Boolean> $default$enabled() {
        return Property.ofValue(true);
    }

    @Generated
    private static Property<List<String>> $default$namespaces() {
        return Property.ofExpression("[\"{{flow.namespace}}\"]");
    }

    @Generated
    private static Property<FileExistComportment> $default$ifExists() {
        return Property.ofValue(FileExistComportment.OVERWRITE);
    }

    @Generated
    private static Property<Boolean> $default$folderPerNamespace() {
        return Property.ofValue(false);
    }

    @Generated
    public static NamespaceFilesBuilder builder() {
        return new NamespaceFilesBuilder();
    }

    @Generated
    public Property<Boolean> getEnabled() {
        return this.enabled;
    }

    @Generated
    public Property<List<String>> getInclude() {
        return this.include;
    }

    @Generated
    public Property<List<String>> getExclude() {
        return this.exclude;
    }

    @Generated
    public Property<List<String>> getNamespaces() {
        return this.namespaces;
    }

    @Generated
    public Property<FileExistComportment> getIfExists() {
        return this.ifExists;
    }

    @Generated
    public Property<Boolean> getFolderPerNamespace() {
        return this.folderPerNamespace;
    }

    @Generated
    public NamespaceFiles() {
        this.enabled = NamespaceFiles.$default$enabled();
        this.namespaces = NamespaceFiles.$default$namespaces();
        this.ifExists = NamespaceFiles.$default$ifExists();
        this.folderPerNamespace = NamespaceFiles.$default$folderPerNamespace();
    }

    @ConstructorProperties(value={"enabled", "include", "exclude", "namespaces", "ifExists", "folderPerNamespace"})
    @Generated
    public NamespaceFiles(Property<Boolean> enabled, Property<List<String>> include, Property<List<String>> exclude, Property<List<String>> namespaces, Property<FileExistComportment> ifExists, Property<Boolean> folderPerNamespace) {
        this.enabled = enabled;
        this.include = include;
        this.exclude = exclude;
        this.namespaces = namespaces;
        this.ifExists = ifExists;
        this.folderPerNamespace = folderPerNamespace;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class NamespaceFilesBuilder {
        @Generated
        private boolean enabled$set;
        @Generated
        private Property<Boolean> enabled$value;
        @Generated
        private Property<List<String>> include;
        @Generated
        private Property<List<String>> exclude;
        @Generated
        private boolean namespaces$set;
        @Generated
        private Property<List<String>> namespaces$value;
        @Generated
        private boolean ifExists$set;
        @Generated
        private Property<FileExistComportment> ifExists$value;
        @Generated
        private boolean folderPerNamespace$set;
        @Generated
        private Property<Boolean> folderPerNamespace$value;

        @Generated
        NamespaceFilesBuilder() {
        }

        @Generated
        public NamespaceFilesBuilder enabled(Property<Boolean> enabled) {
            this.enabled$value = enabled;
            this.enabled$set = true;
            return this;
        }

        @Generated
        public NamespaceFilesBuilder include(Property<List<String>> include) {
            this.include = include;
            return this;
        }

        @Generated
        public NamespaceFilesBuilder exclude(Property<List<String>> exclude) {
            this.exclude = exclude;
            return this;
        }

        @Generated
        public NamespaceFilesBuilder namespaces(Property<List<String>> namespaces) {
            this.namespaces$value = namespaces;
            this.namespaces$set = true;
            return this;
        }

        @Generated
        public NamespaceFilesBuilder ifExists(Property<FileExistComportment> ifExists) {
            this.ifExists$value = ifExists;
            this.ifExists$set = true;
            return this;
        }

        @Generated
        public NamespaceFilesBuilder folderPerNamespace(Property<Boolean> folderPerNamespace) {
            this.folderPerNamespace$value = folderPerNamespace;
            this.folderPerNamespace$set = true;
            return this;
        }

        @Generated
        public NamespaceFiles build() {
            Property<Boolean> enabled$value = this.enabled$value;
            if (!this.enabled$set) {
                enabled$value = NamespaceFiles.$default$enabled();
            }
            Property<List<String>> namespaces$value = this.namespaces$value;
            if (!this.namespaces$set) {
                namespaces$value = NamespaceFiles.$default$namespaces();
            }
            Property<FileExistComportment> ifExists$value = this.ifExists$value;
            if (!this.ifExists$set) {
                ifExists$value = NamespaceFiles.$default$ifExists();
            }
            Property<Boolean> folderPerNamespace$value = this.folderPerNamespace$value;
            if (!this.folderPerNamespace$set) {
                folderPerNamespace$value = NamespaceFiles.$default$folderPerNamespace();
            }
            return new NamespaceFiles(enabled$value, this.include, this.exclude, namespaces$value, ifExists$value, folderPerNamespace$value);
        }

        @Generated
        public String toString() {
            return "NamespaceFiles.NamespaceFilesBuilder(enabled$value=" + String.valueOf(this.enabled$value) + ", include=" + String.valueOf(this.include) + ", exclude=" + String.valueOf(this.exclude) + ", namespaces$value=" + String.valueOf(this.namespaces$value) + ", ifExists$value=" + String.valueOf(this.ifExists$value) + ", folderPerNamespace$value=" + String.valueOf(this.folderPerNamespace$value) + ")";
        }
    }
}

