/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.tasks.logs;

import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.models.tasks.logs.LogRecord;
import java.time.Instant;

public final class LogRecordMapper {
    private LogRecordMapper() {
    }

    public static LogRecord mapToLogRecord(LogEntry log) {
        return LogRecordMapper.mapToLogRecord(log, null);
    }

    public static LogRecord mapToLogRecord(LogEntry log, Integer maxMessageSize) {
        return LogRecord.builder().resource("Kestra").timestampEpochNanos(LogRecordMapper.instantInNanos(log.getTimestamp())).severity(log.getLevel().name()).attributes(log.toLogMap()).bodyValue(LogEntry.toPrettyString(log, maxMessageSize)).build();
    }

    public static long instantInNanos(Instant instant) {
        return instant.getEpochSecond() * 1000000000L + (long)instant.getNano();
    }
}

