/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.tasks.runners;

import io.kestra.core.models.tasks.runners.AbstractLogConsumer;
import io.kestra.core.models.tasks.runners.PluginUtilsService;
import io.kestra.core.runners.RunContext;
import java.time.Instant;

public class DefaultLogConsumer
extends AbstractLogConsumer {
    private final RunContext runContext;

    public DefaultLogConsumer(RunContext runContext) {
        this.runContext = runContext;
    }

    @Override
    public void accept(String line, Boolean isStdErr) {
        this.accept(line, isStdErr, null);
    }

    @Override
    public void accept(String line, Boolean isStdErr, Instant instant) {
        this.outputs.putAll(PluginUtilsService.parseOut(line, this.runContext.logger(), this.runContext, isStdErr, instant));
        if (isStdErr.booleanValue()) {
            this.stdErrCount.incrementAndGet();
        } else {
            this.stdOutCount.incrementAndGet();
        }
    }
}

