/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.triggers;

import io.kestra.core.exceptions.InvalidTriggerConfigurationException;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.models.triggers.WorkerTriggerInterface;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Optional;

public interface PollingTriggerInterface
extends WorkerTriggerInterface {
    @Schema(title="Interval between polling.", description="The interval between 2 different polls of schedule, this can avoid to overload the remote system with too many calls. For most of the triggers that depend on external systems, a minimal interval must be at least PT30S.\nSee [ISO_8601 Durations](https://en.wikipedia.org/wiki/ISO_8601#Durations) for more information of available interval values.")
    @PluginProperty
    public Duration getInterval();

    public Optional<Execution> evaluate(ConditionContext var1, TriggerContext var2) throws Exception;

    default public ZonedDateTime nextEvaluationDate(ConditionContext conditionContext, Optional<? extends TriggerContext> last) throws InvalidTriggerConfigurationException {
        return this.computeNextEvaluationDate();
    }

    default public ZonedDateTime nextEvaluationDate() throws InvalidTriggerConfigurationException {
        return this.computeNextEvaluationDate();
    }

    private ZonedDateTime computeNextEvaluationDate() throws InvalidTriggerConfigurationException {
        Duration interval = this.getInterval();
        try {
            return ZonedDateTime.now().plus(interval);
        }
        catch (ArithmeticException | DateTimeException e) {
            throw new InvalidTriggerConfigurationException("Trigger interval too large", e);
        }
    }
}

