/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.triggers;

import io.kestra.core.models.property.Property;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.Duration;

public interface StatefulTriggerInterface {
    @Schema(title="Trigger event type", description="Defines when the trigger fires.\n- `CREATE`: only for newly discovered entities.\n- `UPDATE`: only when an already-seen entity changes.\n- `CREATE_OR_UPDATE`: fires on either event.\n")
    public Property<On> getOn();

    @Schema(title="State key", description="JSON-type KV key for persisted state.\nDefault: `<namespace>__<flowId>__<triggerId>`\n")
    public Property<String> getStateKey();

    @Schema(title="State TTL", description="TTL for persisted state entries (e.g., PT24H, P7D).")
    public Property<Duration> getStateTtl();

    public static enum On {
        CREATE,
        UPDATE,
        CREATE_OR_UPDATE;

    }
}

