/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.validations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.micronaut.core.annotation.Introspected;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Introspected
public class ValidateConstraintViolation {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidateConstraintViolation.class);
    private String flow;
    private String namespace;
    @NotNull
    private int index;
    private String constraints;
    private boolean outdated;
    private List<String> deprecationPaths;
    private List<String> warnings;
    private List<String> infos;

    @JsonIgnore
    public String getIdentity() {
        return this.flow != null && this.namespace != null ? this.getFlowId() : (this.flow != null ? this.flow : String.valueOf(this.index));
    }

    @JsonIgnore
    public String getIdentity(Path directory) throws IOException {
        return this.flow != null && this.namespace != null ? this.getFlowId() : (this.flow != null ? this.flow : this.getPath(directory));
    }

    private String getPath(Path directory) throws IOException {
        try (Stream<Path> files = Files.walk(directory, new FileVisitOption[0]);){
            String string = String.valueOf(files.toList().get(this.index));
            return string;
        }
    }

    @JsonIgnore
    public String getFlowId() {
        return this.namespace + "." + this.flow;
    }

    @Generated
    protected ValidateConstraintViolation(ValidateConstraintViolationBuilder<?, ?> b) {
        this.flow = b.flow;
        this.namespace = b.namespace;
        this.index = b.index;
        this.constraints = b.constraints;
        this.outdated = b.outdated;
        this.deprecationPaths = b.deprecationPaths;
        this.warnings = b.warnings;
        this.infos = b.infos;
    }

    @Generated
    public static ValidateConstraintViolationBuilder<?, ?> builder() {
        return new ValidateConstraintViolationBuilderImpl();
    }

    @Generated
    public ValidateConstraintViolationBuilder<?, ?> toBuilder() {
        return new ValidateConstraintViolationBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getFlow() {
        return this.flow;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public int getIndex() {
        return this.index;
    }

    @Generated
    public String getConstraints() {
        return this.constraints;
    }

    @Generated
    public boolean isOutdated() {
        return this.outdated;
    }

    @Generated
    public List<String> getDeprecationPaths() {
        return this.deprecationPaths;
    }

    @Generated
    public List<String> getWarnings() {
        return this.warnings;
    }

    @Generated
    public List<String> getInfos() {
        return this.infos;
    }

    @ConstructorProperties(value={"flow", "namespace", "index", "constraints", "outdated", "deprecationPaths", "warnings", "infos"})
    @Generated
    public ValidateConstraintViolation(String flow, String namespace, int index, String constraints, boolean outdated, List<String> deprecationPaths, List<String> warnings, List<String> infos) {
        this.flow = flow;
        this.namespace = namespace;
        this.index = index;
        this.constraints = constraints;
        this.outdated = outdated;
        this.deprecationPaths = deprecationPaths;
        this.warnings = warnings;
        this.infos = infos;
    }

    @Generated
    public ValidateConstraintViolation() {
    }

    @Generated
    public String toString() {
        return "ValidateConstraintViolation(flow=" + this.getFlow() + ", namespace=" + this.getNamespace() + ", index=" + this.getIndex() + ", constraints=" + this.getConstraints() + ", outdated=" + this.isOutdated() + ", deprecationPaths=" + String.valueOf(this.getDeprecationPaths()) + ", warnings=" + String.valueOf(this.getWarnings()) + ", infos=" + String.valueOf(this.getInfos()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidateConstraintViolation)) {
            return false;
        }
        ValidateConstraintViolation other = (ValidateConstraintViolation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        if (this.isOutdated() != other.isOutdated()) {
            return false;
        }
        String this$flow = this.getFlow();
        String other$flow = other.getFlow();
        if (this$flow == null ? other$flow != null : !this$flow.equals(other$flow)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$constraints = this.getConstraints();
        String other$constraints = other.getConstraints();
        if (this$constraints == null ? other$constraints != null : !this$constraints.equals(other$constraints)) {
            return false;
        }
        List<String> this$deprecationPaths = this.getDeprecationPaths();
        List<String> other$deprecationPaths = other.getDeprecationPaths();
        if (this$deprecationPaths == null ? other$deprecationPaths != null : !((Object)this$deprecationPaths).equals(other$deprecationPaths)) {
            return false;
        }
        List<String> this$warnings = this.getWarnings();
        List<String> other$warnings = other.getWarnings();
        if (this$warnings == null ? other$warnings != null : !((Object)this$warnings).equals(other$warnings)) {
            return false;
        }
        List<String> this$infos = this.getInfos();
        List<String> other$infos = other.getInfos();
        return !(this$infos == null ? other$infos != null : !((Object)this$infos).equals(other$infos));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ValidateConstraintViolation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIndex();
        result = result * 59 + (this.isOutdated() ? 79 : 97);
        String $flow = this.getFlow();
        result = result * 59 + ($flow == null ? 43 : $flow.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $constraints = this.getConstraints();
        result = result * 59 + ($constraints == null ? 43 : $constraints.hashCode());
        List<String> $deprecationPaths = this.getDeprecationPaths();
        result = result * 59 + ($deprecationPaths == null ? 43 : ((Object)$deprecationPaths).hashCode());
        List<String> $warnings = this.getWarnings();
        result = result * 59 + ($warnings == null ? 43 : ((Object)$warnings).hashCode());
        List<String> $infos = this.getInfos();
        result = result * 59 + ($infos == null ? 43 : ((Object)$infos).hashCode());
        return result;
    }

    @Generated
    public static abstract class ValidateConstraintViolationBuilder<C extends ValidateConstraintViolation, B extends ValidateConstraintViolationBuilder<C, B>> {
        @Generated
        private String flow;
        @Generated
        private String namespace;
        @Generated
        private int index;
        @Generated
        private String constraints;
        @Generated
        private boolean outdated;
        @Generated
        private List<String> deprecationPaths;
        @Generated
        private List<String> warnings;
        @Generated
        private List<String> infos;

        @Generated
        protected B $fillValuesFrom(C instance) {
            ValidateConstraintViolationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ValidateConstraintViolation instance, ValidateConstraintViolationBuilder<?, ?> b) {
            b.flow(instance.flow);
            b.namespace(instance.namespace);
            b.index(instance.index);
            b.constraints(instance.constraints);
            b.outdated(instance.outdated);
            b.deprecationPaths(instance.deprecationPaths);
            b.warnings(instance.warnings);
            b.infos(instance.infos);
        }

        @Generated
        public B flow(String flow) {
            this.flow = flow;
            return this.self();
        }

        @Generated
        public B namespace(String namespace) {
            this.namespace = namespace;
            return this.self();
        }

        @Generated
        public B index(int index) {
            this.index = index;
            return this.self();
        }

        @Generated
        public B constraints(String constraints) {
            this.constraints = constraints;
            return this.self();
        }

        @Generated
        public B outdated(boolean outdated) {
            this.outdated = outdated;
            return this.self();
        }

        @Generated
        public B deprecationPaths(List<String> deprecationPaths) {
            this.deprecationPaths = deprecationPaths;
            return this.self();
        }

        @Generated
        public B warnings(List<String> warnings) {
            this.warnings = warnings;
            return this.self();
        }

        @Generated
        public B infos(List<String> infos) {
            this.infos = infos;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "ValidateConstraintViolation.ValidateConstraintViolationBuilder(flow=" + this.flow + ", namespace=" + this.namespace + ", index=" + this.index + ", constraints=" + this.constraints + ", outdated=" + this.outdated + ", deprecationPaths=" + String.valueOf(this.deprecationPaths) + ", warnings=" + String.valueOf(this.warnings) + ", infos=" + String.valueOf(this.infos) + ")";
        }
    }

    @Generated
    private static final class ValidateConstraintViolationBuilderImpl
    extends ValidateConstraintViolationBuilder<ValidateConstraintViolation, ValidateConstraintViolationBuilderImpl> {
        @Generated
        private ValidateConstraintViolationBuilderImpl() {
        }

        @Override
        @Generated
        protected ValidateConstraintViolationBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ValidateConstraintViolation build() {
            return new ValidateConstraintViolation(this);
        }
    }
}

