/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.plugins;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public record PluginArtifact(String groupId, String artifactId, String extension, String classifier, String version, URI uri) implements Comparable<PluginArtifact>
{
    private static final Pattern ARTIFACT_PATTERN = Pattern.compile("([^: ]+):([^: ]+)(:([^: ]*)(:([^: ]+))?)?:([^: ]+)");
    private static final Pattern FILENAME_PATTERN = Pattern.compile("^(?<groupId>[\\w_]+)__(?<artifactId>[\\w-_]+)(?:__(?<classifier>[\\w-_]+))?__(?<version>\\d+_\\d+_\\d+(-[a-zA-Z0-9-]+)?|([a-zA-Z0-9]+))\\.jar$");
    public static final String JAR_EXTENSION = "jar";
    public static final String KESTRA_GROUP_ID = "io.kestra";

    public static PluginArtifact fromFile(File file) throws IOException {
        try (JarFile jarFile = new JarFile(file);){
            Manifest manifest = jarFile.getManifest();
            String version = manifest.getMainAttributes().getValue("X-Kestra-Version");
            String artifactId = manifest.getMainAttributes().getValue("X-Kestra-Name");
            String groupId = manifest.getMainAttributes().getValue("X-Kestra-Group");
            PluginArtifact pluginArtifact = new PluginArtifact(groupId, artifactId, JAR_EXTENSION, null, version, file.toURI());
            return pluginArtifact;
        }
    }

    public static PluginArtifact fromCoordinates(String coordinates) {
        Matcher m = ARTIFACT_PATTERN.matcher(coordinates);
        if (!m.matches()) {
            throw new IllegalArgumentException("Bad artifact coordinates " + coordinates + ", expected format is <groupId>:<artifactId>[:<extension>[:<classifier>]]:<version>");
        }
        return new PluginArtifact(m.group(1), m.group(2), Optional.ofNullable(m.group(4)).filter(Predicate.not(String::isEmpty)).orElse(JAR_EXTENSION), Optional.ofNullable(m.group(6)).filter(Predicate.not(String::isEmpty)).orElse(null), "LATEST".equalsIgnoreCase(m.group(7)) ? "LATEST" : m.group(7), null);
    }

    public static PluginArtifact fromFileName(String fileName) {
        String version;
        Matcher matcher = FILENAME_PATTERN.matcher(fileName);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid artifact filename '" + fileName + "', expected format is <groupId>__<artifactId>[__<classifier>]__<version>.jar");
        }
        String[] parts = fileName.substring(0, fileName.lastIndexOf(".")).split("__");
        String groupId = parts[0].replace("_", ".");
        String artifactId = parts[1];
        String classifier = null;
        if (parts.length == 4) {
            classifier = parts[2];
            version = parts[3].replace("_", ".");
        } else {
            version = parts[2].replace("_", ".");
        }
        return new PluginArtifact(groupId, artifactId, JAR_EXTENSION, classifier, version, null);
    }

    public PluginArtifact relocateTo(URI uri) {
        return new PluginArtifact(this.groupId, this.artifactId, this.extension, this.classifier, this.version, uri);
    }

    @Override
    public String toString() {
        return this.toCoordinates();
    }

    @JsonIgnore
    public boolean isOfficial() {
        return this.groupId.startsWith(KESTRA_GROUP_ID);
    }

    public String toCoordinates() {
        return Stream.of(this.groupId, this.artifactId, this.extension, this.classifier, this.version).filter(Objects::nonNull).filter(it -> !it.isEmpty()).collect(Collectors.joining(":"));
    }

    public String toFileName() {
        String name = Stream.of(this.groupId.replace(".", "_"), this.artifactId, this.classifier, this.version.replace(".", "_")).filter(Objects::nonNull).filter(it -> !it.isEmpty()).collect(Collectors.joining("__"));
        return name + "." + this.extension;
    }

    @Override
    public int compareTo(PluginArtifact that) {
        return this.toCoordinates().compareTo(that.toCoordinates());
    }

    @Generated
    public static PluginArtifactBuilder builder() {
        return new PluginArtifactBuilder();
    }

    @Generated
    public PluginArtifactBuilder toBuilder() {
        return new PluginArtifactBuilder().groupId(this.groupId).artifactId(this.artifactId).extension(this.extension).classifier(this.classifier).version(this.version).uri(this.uri);
    }

    @Generated
    public static class PluginArtifactBuilder {
        @Generated
        private String groupId;
        @Generated
        private String artifactId;
        @Generated
        private String extension;
        @Generated
        private String classifier;
        @Generated
        private String version;
        @Generated
        private URI uri;

        @Generated
        PluginArtifactBuilder() {
        }

        @Generated
        public PluginArtifactBuilder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Generated
        public PluginArtifactBuilder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Generated
        public PluginArtifactBuilder extension(String extension) {
            this.extension = extension;
            return this;
        }

        @Generated
        public PluginArtifactBuilder classifier(String classifier) {
            this.classifier = classifier;
            return this;
        }

        @Generated
        public PluginArtifactBuilder version(String version) {
            this.version = version;
            return this;
        }

        @Generated
        public PluginArtifactBuilder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        @Generated
        public PluginArtifact build() {
            return new PluginArtifact(this.groupId, this.artifactId, this.extension, this.classifier, this.version, this.uri);
        }

        @Generated
        public String toString() {
            return "PluginArtifact.PluginArtifactBuilder(groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", extension=" + this.extension + ", classifier=" + this.classifier + ", version=" + this.version + ", uri=" + String.valueOf(this.uri) + ")";
        }
    }
}

