/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.plugins;

import io.kestra.core.contexts.KestraContext;
import io.kestra.core.plugins.PluginArtifact;
import io.kestra.core.plugins.PluginResolutionResult;
import io.kestra.core.utils.ListUtils;
import io.kestra.core.utils.Version;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.client.HttpClient;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.Base64;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginCatalogService {
    private static final Logger log = LoggerFactory.getLogger(PluginCatalogService.class);
    private static final Duration MAX_CACHE_DURATION = Duration.ofHours(1L);
    private final HttpClient httpClient;
    private CompletableFuture<List<PluginManifest>> plugins;
    private List<PluginManifest> loaded = List.of();
    private Instant cacheLastLoaded = Instant.now();
    private final AtomicBoolean isLoaded = new AtomicBoolean(false);
    private final boolean icons;
    private final boolean oss;
    private final Version currentStableVersion;

    public PluginCatalogService(HttpClient httpClient, boolean icons, boolean communityOnly) {
        this.httpClient = httpClient;
        this.icons = icons;
        this.oss = communityOnly;
        Version version = Version.of(KestraContext.getContext().getVersion());
        this.currentStableVersion = new Version(version.majorVersion(), version.minorVersion(), version.patchVersion(), null);
        this.isLoaded.set(true);
        this.plugins = CompletableFuture.supplyAsync(this::load);
    }

    public List<PluginResolutionResult> resolveVersions(List<PluginArtifact> artifacts) {
        if (ListUtils.isEmpty(artifacts)) {
            return List.of();
        }
        Map pluginsByGroupAndArtifactId = this.getAllCompatiblePlugins().stream().collect(Collectors.toMap(it -> it.groupId() + ":" + it.artifactId(), Function.identity()));
        return artifacts.stream().map(it -> {
            List<String> versions = Optional.ofNullable((ApiPluginArtifact)pluginsByGroupAndArtifactId.get(it.groupId() + ":" + it.artifactId())).map(ApiPluginArtifact::versions).orElse(List.of());
            String resolvedVersion = null;
            if (!versions.isEmpty()) {
                resolvedVersion = it.version().equalsIgnoreCase("LATEST") ? (String)versions.getFirst() : (versions.contains(it.version()) ? it.version() : null);
            }
            return new PluginResolutionResult((PluginArtifact)it, resolvedVersion, versions, resolvedVersion != null);
        }).toList();
    }

    public synchronized List<PluginManifest> get() {
        try {
            List<PluginManifest> artifacts = this.plugins.get();
            if (!artifacts.isEmpty()) {
                this.loaded = artifacts;
            }
            if (this.cacheLastLoaded.plus(MAX_CACHE_DURATION).isBefore(Instant.now()) && this.isLoaded.compareAndSet(false, true)) {
                this.plugins = CompletableFuture.supplyAsync(this::load);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
                log.warn("Failed to retrieve available plugins from Kestra API. Cause: Interrupted");
            }
            Throwable cause = e.getCause() != null ? e.getCause() : e;
            log.warn("Failed to retrieve available plugins from Kestra API. Cause: {}", (Object)cause.getMessage());
        }
        return this.loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PluginManifest> load() {
        try {
            List plugins;
            List<PluginManifest> artifacts;
            if (log.isDebugEnabled()) {
                log.debug("(Re)loading available plugin artifacts from configured Kestra API.");
            }
            if (!(artifacts = (plugins = (List)this.httpClient.toBlocking().exchange((HttpRequest)HttpRequest.create((HttpMethod)HttpMethod.GET, (String)"/v1/plugins"), Argument.listOf((Argument)Argument.mapOf(String.class, Object.class))).body()).parallelStream().filter(plugin -> !plugin.get("name").equals("core")).filter(plugin -> !this.oss || !"EE".equals(plugin.get("license"))).map(plugin -> {
                String groupId = "EE".equals(plugin.get("license")) ? "io.kestra.plugin.ee" : "io.kestra.plugin";
                String artifactId = (String)plugin.get("name");
                String icon = null;
                if (this.icons) {
                    HttpResponse response = this.httpClient.toBlocking().exchange((HttpRequest)HttpRequest.create((HttpMethod)HttpMethod.GET, (String)("/v1/plugins/icons/" + String.valueOf(plugin.get("group")))), String.class);
                    icon = response.getBody().map(svg -> Base64.getEncoder().encodeToString(svg.getBytes(StandardCharsets.UTF_8))).orElse(null);
                }
                return new PluginManifest((String)plugin.get("title"), icon, groupId, artifactId);
            }).sorted(Comparator.comparing(PluginManifest::title)).toList()).isEmpty()) {
                this.cacheLastLoaded = Instant.now();
            }
            if (log.isDebugEnabled()) {
                log.debug("Available plugin artifacts loaded (count={})", (Object)artifacts.size());
            }
            List<PluginManifest> list = artifacts;
            return list;
        }
        finally {
            this.isLoaded.set(false);
        }
    }

    private List<ApiPluginArtifact> getAllCompatiblePlugins() {
        MutableHttpRequest request = HttpRequest.create((HttpMethod)HttpMethod.GET, (String)("/v1/plugins/artifacts/core-compatibility/" + String.valueOf(this.currentStableVersion)));
        if (this.oss) {
            request.getParameters().add((CharSequence)"license", (CharSequence)"OPENSOURCE");
        }
        try {
            return (List)this.httpClient.toBlocking().exchange((HttpRequest)request, Argument.listOf(ApiPluginArtifact.class)).body();
        }
        catch (Exception e) {
            log.debug("Failed to retrieve available plugins from Kestra API. Cause: ", (Throwable)e);
            return List.of();
        }
    }

    public record ApiPluginArtifact(String groupId, String artifactId, String license, List<String> versions) {
    }

    public record PluginManifest(String title, String icon, String groupId, String artifactId) {
        @Override
        public String toString() {
            return this.groupId + ":" + this.artifactId + ":LATEST";
        }
    }
}

