/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.plugins;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Objects;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginClassLoader
extends URLClassLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PluginClassLoader.class);
    private static final Pattern EXCLUDES;
    private final ClassLoader parent;
    private final URL pluginLocation;

    public static PluginClassLoader of(URL pluginLocation, URL[] urls, ClassLoader parent) {
        return AccessController.doPrivileged(() -> new PluginClassLoader(pluginLocation, urls, parent));
    }

    private PluginClassLoader(URL pluginLocation, URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.parent = parent;
        this.pluginLocation = pluginLocation;
    }

    public String location() {
        return this.pluginLocation.toString();
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> loadedClass = this.findLoadedClass(name);
            if (loadedClass == null && PluginClassLoader.shouldLoadFromUrls(name)) {
                try {
                    loadedClass = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    log.debug("Class '{}' not found on '{}' for plugin '{}', delegating to parent '{}'", new Object[]{name, this.getName(), this.pluginLocation, this.parent.getName()});
                }
                catch (LinkageError e) {
                    log.debug("Class '{}'already in classpath for plugin '{}', delegating to parent '{}'", new Object[]{name, this.pluginLocation, this.parent.getName()});
                }
            }
            if (loadedClass == null) {
                loadedClass = super.loadClass(name, resolve);
            }
            if (resolve) {
                this.resolveClass(loadedClass);
            }
            return loadedClass;
        }
    }

    private static boolean shouldLoadFromUrls(String name) {
        return !EXCLUDES.matcher(name).matches();
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Objects.requireNonNull(name);
        return this.findResources(name);
    }

    @Override
    public URL getResource(String name) {
        Objects.requireNonNull(name);
        return this.findResource(name);
    }

    public String toString() {
        return "PluginClassLoader[location=" + String.valueOf(this.pluginLocation) + "] ";
    }

    static {
        ClassLoader.registerAsParallelCapable();
        EXCLUDES = Pattern.compile("^(?:java|javax|jakarta|io.kestra.core|io.kestra.plugin.core|org.slf4j|ch.qos.logback|io.swagger|com.fasterxml.jackson.core|com.fasterxml.jackson.annotation|com.fasterxml.jackson.module|com.fasterxml.jackson.databind|com.fasterxml.jackson.dataformat.ion|com.fasterxml.jackson.dataformat.yaml|com.fasterxml.jackson.dataformat.xml|org.reactivestreams|dev.failsafe|reactor|io.opentelemetry|io.netty)\\..*$");
    }
}

