/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.plugins;

import io.kestra.core.plugins.ExternalPlugin;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PluginResolver.class);
    private final Path pluginPath;

    public PluginResolver(Path pluginPath) {
        Objects.requireNonNull(pluginPath, "pluginPath cannot be null");
        this.pluginPath = pluginPath;
    }

    private static boolean isArchiveFile(Path path) {
        String lowerCased = path.toString().toLowerCase();
        return lowerCased.endsWith(".jar") || lowerCased.endsWith(".zip");
    }

    private static boolean isClassFile(Path path) {
        return path.toString().toLowerCase().endsWith(".class");
    }

    public List<ExternalPlugin> resolves() {
        ArrayList<ExternalPlugin> plugins = new ArrayList<ExternalPlugin>(100);
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(this.pluginPath, entry -> Files.isDirectory(entry, new LinkOption[0]) || PluginResolver.isArchiveFile(entry));){
            for (Path path : paths) {
                List<URL> resources = PluginResolver.resolveUrlsForPluginPath(path);
                plugins.add(new ExternalPlugin(path.toUri().toURL(), resources.toArray(new URL[0])));
            }
        }
        catch (MalformedURLException | InvalidPathException e) {
            log.error("Invalid plugin path '{}', path ignored.", (Object)this.pluginPath, (Object)e);
        }
        catch (IOException e) {
            log.error("Error while listing plugin path '{}' path ignored.", (Object)this.pluginPath, (Object)e);
        }
        return plugins;
    }

    private static List<URL> resolveUrlsForPluginPath(Path path) throws IOException {
        ArrayList<Path> archives = new ArrayList<Path>();
        boolean containsClassFiles = false;
        if (PluginResolver.isArchiveFile(path)) {
            archives.add(path);
        } else {
            LinkedList<Path> directories = new LinkedList<Path>();
            directories.add(path);
            while (!directories.isEmpty()) {
                Path directory = (Path)directories.poll();
                try {
                    DirectoryStream<Path> stream = Files.newDirectoryStream(directory, entry -> Files.isDirectory(entry, new LinkOption[0]) || PluginResolver.isArchiveFile(entry) || PluginResolver.isClassFile(entry));
                    try {
                        for (Path entry2 : stream) {
                            if (PluginResolver.isArchiveFile(entry2)) {
                                log.debug("Detected plugin jar: {}", (Object)entry2);
                                archives.add(entry2);
                                continue;
                            }
                            if (PluginResolver.isClassFile(entry2)) {
                                log.debug("Detected plugin class file: {}", (Object)entry2);
                                containsClassFiles = true;
                                continue;
                            }
                            directories.add(entry2);
                        }
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (InvalidPathException e) {
                    log.error("Invalid plugin path '{}', path ignored.", (Object)directory, (Object)e);
                }
                catch (IOException e) {
                    log.error("Error while listing plugin path '{}' path ignored.", (Object)directory, (Object)e);
                }
            }
        }
        if (containsClassFiles) {
            if (archives.isEmpty()) {
                return Collections.singletonList(path.toUri().toURL());
            }
            log.error("Plugin path '{}' contains both java class files and JARs, class files will be ignored and only archives will be scanned.", (Object)path);
        }
        ArrayList<URL> urls = new ArrayList<URL>(archives.size());
        for (Path archive : archives) {
            urls.add(archive.toUri().toURL());
        }
        return urls;
    }
}

