/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.reporter;

import io.kestra.core.reporter.Reportable;
import io.kestra.core.reporter.Type;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ReportableRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReportableRegistry.class);
    private final Map<Type, Reportable<?>> reportables = new ConcurrentHashMap();

    @Inject
    public ReportableRegistry(List<Reportable<?>> reportables) {
        reportables.forEach(reportable -> this.reportables.put(reportable.type(), (Reportable<?>)reportable));
    }

    public void register(Reportable<?> reportable) {
        Objects.requireNonNull(reportable, "reportable must not be null");
        if (this.reportables.containsKey(reportable.type())) {
            log.warn("Event already registered for type '{}'", (Object)reportable.type());
        } else {
            this.reportables.put(reportable.type(), reportable);
        }
    }

    public List<Reportable<?>> getAll() {
        return List.copyOf(this.reportables.values());
    }
}

