/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.reporter.reports;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.kestra.core.contexts.KestraContext;
import io.kestra.core.models.ServerType;
import io.kestra.core.models.collectors.ExecutionUsage;
import io.kestra.core.models.collectors.FlowUsage;
import io.kestra.core.reporter.AbstractReportable;
import io.kestra.core.reporter.Reportable;
import io.kestra.core.reporter.Schedules;
import io.kestra.core.reporter.Types;
import io.kestra.core.reporter.model.Count;
import io.kestra.core.repositories.DashboardRepositoryInterface;
import io.kestra.core.repositories.ExecutionRepositoryInterface;
import io.kestra.core.repositories.FlowRepositoryInterface;
import io.micronaut.core.annotation.Introspected;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Instant;
import java.util.Objects;
import lombok.Generated;

@Singleton
public class FeatureUsageReport
extends AbstractReportable<UsageEvent> {
    private final FlowRepositoryInterface flowRepository;
    private final ExecutionRepositoryInterface executionRepository;
    private final DashboardRepositoryInterface dashboardRepository;
    private final boolean enabled;

    @Inject
    public FeatureUsageReport(FlowRepositoryInterface flowRepository, ExecutionRepositoryInterface executionRepository, DashboardRepositoryInterface dashboardRepository) {
        super(Types.USAGE, Schedules.hourly(), true);
        this.flowRepository = flowRepository;
        this.executionRepository = executionRepository;
        this.dashboardRepository = dashboardRepository;
        ServerType serverType = KestraContext.getContext().getServerType();
        this.enabled = ServerType.EXECUTOR.equals((Object)serverType) || ServerType.STANDALONE.equals((Object)serverType);
    }

    @Override
    public UsageEvent report(Instant now, Reportable.TimeInterval interval) {
        return ((UsageEvent.UsageEventBuilder)((UsageEvent.UsageEventBuilder)((UsageEvent.UsageEventBuilder)UsageEvent.builder().flows(FlowUsage.of(this.flowRepository))).executions(ExecutionUsage.of(this.executionRepository, interval.from(), interval.to()))).dashboards(new Count(this.dashboardRepository.count()))).build();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public UsageEvent report(Instant now, Reportable.TimeInterval interval, String tenant) {
        Objects.requireNonNull(tenant, "tenant is null");
        Objects.requireNonNull(interval, "interval is null");
        return ((UsageEvent.UsageEventBuilder)((UsageEvent.UsageEventBuilder)UsageEvent.builder().flows(FlowUsage.of(tenant, this.flowRepository))).executions(ExecutionUsage.of(tenant, this.executionRepository, interval.from(), interval.to()))).build();
    }

    @Introspected
    @JsonDeserialize(builder=UsageEventBuilderImpl.class)
    public static class UsageEvent
    implements Reportable.Event {
        private ExecutionUsage executions;
        private FlowUsage flows;
        private Count dashboards;

        @Generated
        protected UsageEvent(UsageEventBuilder<?, ?> b) {
            this.executions = b.executions;
            this.flows = b.flows;
            this.dashboards = b.dashboards;
        }

        @Generated
        public static UsageEventBuilder<?, ?> builder() {
            return new UsageEventBuilderImpl();
        }

        @Generated
        public UsageEventBuilder<?, ?> toBuilder() {
            return new UsageEventBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public ExecutionUsage getExecutions() {
            return this.executions;
        }

        @Generated
        public FlowUsage getFlows() {
            return this.flows;
        }

        @Generated
        public Count getDashboards() {
            return this.dashboards;
        }

        @Generated
        public static abstract class UsageEventBuilder<C extends UsageEvent, B extends UsageEventBuilder<C, B>> {
            @Generated
            private ExecutionUsage executions;
            @Generated
            private FlowUsage flows;
            @Generated
            private Count dashboards;

            @Generated
            protected B $fillValuesFrom(C instance) {
                UsageEventBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(UsageEvent instance, UsageEventBuilder<?, ?> b) {
                b.executions(instance.executions);
                b.flows(instance.flows);
                b.dashboards(instance.dashboards);
            }

            @Generated
            public B executions(ExecutionUsage executions) {
                this.executions = executions;
                return this.self();
            }

            @Generated
            public B flows(FlowUsage flows) {
                this.flows = flows;
                return this.self();
            }

            @Generated
            public B dashboards(Count dashboards) {
                this.dashboards = dashboards;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "FeatureUsageReport.UsageEvent.UsageEventBuilder(executions=" + String.valueOf(this.executions) + ", flows=" + String.valueOf(this.flows) + ", dashboards=" + String.valueOf(this.dashboards) + ")";
            }
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class UsageEventBuilderImpl
        extends UsageEventBuilder<UsageEvent, UsageEventBuilderImpl> {
            @Generated
            private UsageEventBuilderImpl() {
            }

            @Override
            @Generated
            protected UsageEventBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public UsageEvent build() {
                return new UsageEvent(this);
            }
        }
    }
}

