/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.reporter.reports;

import io.kestra.core.contexts.KestraContext;
import io.kestra.core.metrics.MetricRegistry;
import io.kestra.core.models.ServerType;
import io.kestra.core.models.collectors.PluginMetric;
import io.kestra.core.plugins.PluginRegistry;
import io.kestra.core.reporter.AbstractReportable;
import io.kestra.core.reporter.Reportable;
import io.kestra.core.reporter.Schedules;
import io.kestra.core.reporter.Types;
import io.kestra.core.utils.ListUtils;
import io.micrometer.core.instrument.Timer;
import io.micronaut.core.annotation.Introspected;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

@Singleton
public class PluginMetricReport
extends AbstractReportable<PluginMetricEvent> {
    private final PluginRegistry pluginRegistry;
    private final MetricRegistry metricRegistry;
    private final boolean enabled;

    @Inject
    public PluginMetricReport(PluginRegistry pluginRegistry, MetricRegistry metricRegistry) {
        super(Types.PLUGIN_METRICS, Schedules.daily(), false);
        this.metricRegistry = metricRegistry;
        this.pluginRegistry = pluginRegistry;
        ServerType serverType = KestraContext.getContext().getServerType();
        this.enabled = ServerType.SCHEDULER.equals((Object)serverType) || ServerType.WORKER.equals((Object)serverType) || ServerType.STANDALONE.equals((Object)serverType);
    }

    @Override
    public PluginMetricEvent report(Instant now, Reportable.TimeInterval period) {
        return PluginMetricEvent.builder().pluginMetrics(this.pluginMetrics()).build();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    private List<PluginMetric> pluginMetrics() {
        List taskMetrics = this.pluginRegistry.plugins().stream().flatMap(registeredPlugin -> registeredPlugin.getTasks().stream()).map(Class::getName).map(this::taskMetric).flatMap(Optional::stream).toList();
        List triggerMetrics = this.pluginRegistry.plugins().stream().flatMap(registeredPlugin -> registeredPlugin.getTriggers().stream()).map(Class::getName).map(this::triggerMetric).flatMap(Optional::stream).toList();
        return ListUtils.concat(taskMetrics, triggerMetrics);
    }

    private Optional<PluginMetric> taskMetric(String type) {
        Timer duration = this.metricRegistry.find("worker.ended.duration").tag("task_type", type).timer();
        return this.fromTimer(type, duration);
    }

    private Optional<PluginMetric> triggerMetric(String type) {
        Timer duration = this.metricRegistry.find("worker.trigger.duration").tag("trigger_type", type).timer();
        if (duration == null) {
            duration = this.metricRegistry.find("scheduler.trigger.evaluation.duration").tag("trigger_type", type).timer();
        }
        return this.fromTimer(type, duration);
    }

    private Optional<PluginMetric> fromTimer(String type, Timer timer) {
        if (timer == null || timer.count() == 0L) {
            return Optional.empty();
        }
        double count = timer.count();
        double totalTime = timer.totalTime(TimeUnit.MILLISECONDS);
        double meanTime = timer.mean(TimeUnit.MILLISECONDS);
        return Optional.of(new PluginMetric(type, count, totalTime, meanTime));
    }

    @Introspected
    public record PluginMetricEvent(List<PluginMetric> pluginMetrics) implements Reportable.Event
    {
        @Generated
        public static PluginMetricEventBuilder builder() {
            return new PluginMetricEventBuilder();
        }

        @Generated
        public static class PluginMetricEventBuilder {
            @Generated
            private List<PluginMetric> pluginMetrics;

            @Generated
            PluginMetricEventBuilder() {
            }

            @Generated
            public PluginMetricEventBuilder pluginMetrics(List<PluginMetric> pluginMetrics) {
                this.pluginMetrics = pluginMetrics;
                return this;
            }

            @Generated
            public PluginMetricEvent build() {
                return new PluginMetricEvent(this.pluginMetrics);
            }

            @Generated
            public String toString() {
                return "PluginMetricReport.PluginMetricEvent.PluginMetricEventBuilder(pluginMetrics=" + String.valueOf(this.pluginMetrics) + ")";
            }
        }
    }
}

