/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.reporter.reports;

import io.kestra.core.contexts.KestraContext;
import io.kestra.core.models.ServerType;
import io.kestra.core.models.collectors.PluginUsage;
import io.kestra.core.plugins.PluginRegistry;
import io.kestra.core.reporter.AbstractReportable;
import io.kestra.core.reporter.Reportable;
import io.kestra.core.reporter.Schedules;
import io.kestra.core.reporter.Types;
import io.micronaut.core.annotation.Introspected;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Instant;
import java.util.List;
import lombok.Generated;

@Singleton
public class PluginUsageReport
extends AbstractReportable<PluginUsageEvent> {
    private final PluginRegistry pluginRegistry;
    private final boolean enabled;

    @Inject
    public PluginUsageReport(PluginRegistry pluginRegistry) {
        super(Types.PLUGIN_USAGE, Schedules.daily(), false);
        this.pluginRegistry = pluginRegistry;
        ServerType serverType = KestraContext.getContext().getServerType();
        this.enabled = ServerType.EXECUTOR.equals((Object)serverType) || ServerType.STANDALONE.equals((Object)serverType);
    }

    @Override
    public PluginUsageEvent report(Instant now, Reportable.TimeInterval period) {
        return PluginUsageEvent.builder().plugins(PluginUsage.of(this.pluginRegistry)).build();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Introspected
    public record PluginUsageEvent(List<PluginUsage> plugins) implements Reportable.Event
    {
        @Generated
        public static PluginUsageEventBuilder builder() {
            return new PluginUsageEventBuilder();
        }

        @Generated
        public static class PluginUsageEventBuilder {
            @Generated
            private List<PluginUsage> plugins;

            @Generated
            PluginUsageEventBuilder() {
            }

            @Generated
            public PluginUsageEventBuilder plugins(List<PluginUsage> plugins) {
                this.plugins = plugins;
                return this;
            }

            @Generated
            public PluginUsageEvent build() {
                return new PluginUsageEvent(this.plugins);
            }

            @Generated
            public String toString() {
                return "PluginUsageReport.PluginUsageEvent.PluginUsageEventBuilder(plugins=" + String.valueOf(this.plugins) + ")";
            }
        }
    }
}

