/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.reporter.reports;

import io.kestra.core.contexts.KestraContext;
import io.kestra.core.models.ServerType;
import io.kestra.core.models.collectors.ServiceUsage;
import io.kestra.core.reporter.AbstractReportable;
import io.kestra.core.reporter.Reportable;
import io.kestra.core.reporter.Schedules;
import io.kestra.core.reporter.Types;
import io.kestra.core.repositories.ServiceInstanceRepositoryInterface;
import io.micronaut.core.annotation.Introspected;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.time.Instant;
import lombok.Generated;

@Singleton
public class ServiceUsageReport
extends AbstractReportable<ServiceUsageEvent> {
    private final ServiceInstanceRepositoryInterface serviceInstanceRepository;
    private final boolean isEnabled;

    @Inject
    public ServiceUsageReport(ServiceInstanceRepositoryInterface serviceInstanceRepository) {
        super(Types.SERVICE_USAGE, Schedules.daily(), false);
        this.serviceInstanceRepository = serviceInstanceRepository;
        ServerType serverType = KestraContext.getContext().getServerType();
        this.isEnabled = ServerType.STANDALONE.equals((Object)serverType) || ServerType.EXECUTOR.equals((Object)serverType);
    }

    @Override
    public ServiceUsageEvent report(Instant now, Reportable.TimeInterval period) {
        return ServiceUsageEvent.builder().services(ServiceUsage.of(period.from().toInstant(), period.to().toInstant(), this.serviceInstanceRepository, Duration.ofMinutes(5L))).build();
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Introspected
    public record ServiceUsageEvent(ServiceUsage services) implements Reportable.Event
    {
        @Generated
        public static ServiceUsageEventBuilder builder() {
            return new ServiceUsageEventBuilder();
        }

        @Generated
        public static class ServiceUsageEventBuilder {
            @Generated
            private ServiceUsage services;

            @Generated
            ServiceUsageEventBuilder() {
            }

            @Generated
            public ServiceUsageEventBuilder services(ServiceUsage services) {
                this.services = services;
                return this;
            }

            @Generated
            public ServiceUsageEvent build() {
                return new ServiceUsageEvent(this.services);
            }

            @Generated
            public String toString() {
                return "ServiceUsageReport.ServiceUsageEvent.ServiceUsageEventBuilder(services=" + String.valueOf(this.services) + ")";
            }
        }
    }
}

