/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.repositories;

import io.kestra.core.models.QueryFilter;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.statistics.DailyExecutionStatistics;
import io.kestra.core.models.executions.statistics.ExecutionCount;
import io.kestra.core.models.executions.statistics.Flow;
import io.kestra.core.models.flows.FlowScope;
import io.kestra.core.models.flows.State;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.QueryBuilderInterface;
import io.kestra.core.repositories.SaveRepositoryInterface;
import io.kestra.core.utils.DateUtils;
import io.kestra.plugin.core.dashboard.data.IExecutions;
import io.micronaut.data.model.Pageable;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import reactor.core.publisher.Flux;

public interface ExecutionRepositoryInterface
extends SaveRepositoryInterface<Execution>,
QueryBuilderInterface<IExecutions.Fields> {
    default public Optional<Execution> findById(String tenantId, String id) {
        return this.findById(tenantId, id, false);
    }

    public Optional<Execution> findById(String var1, String var2, boolean var3);

    public Optional<Execution> findByIdWithoutAcl(String var1, String var2);

    public ArrayListTotal<Execution> findByFlowId(String var1, String var2, String var3, Pageable var4);

    public Flux<Execution> findAllByTriggerExecutionId(String var1, String var2);

    public Optional<Execution> findLatestForStates(String var1, String var2, String var3, List<State.Type> var4);

    public ArrayListTotal<Execution> find(Pageable var1, @Nullable String var2, @Nullable List<QueryFilter> var3);

    default public Flux<Execution> find(@Nullable String query, @Nullable String tenantId, @Nullable List<FlowScope> scope, @Nullable String namespace, @Nullable String flowId, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate, @Nullable List<State.Type> state, @Nullable Map<String, String> labels, @Nullable String triggerExecutionId, @Nullable ChildFilter childFilter) {
        return this.find(query, tenantId, scope, namespace, flowId, startDate, endDate, state, labels, triggerExecutionId, childFilter, false);
    }

    public Flux<Execution> find(@Nullable String var1, @Nullable String var2, @Nullable List<FlowScope> var3, @Nullable String var4, @Nullable String var5, @Nullable ZonedDateTime var6, @Nullable ZonedDateTime var7, @Nullable List<State.Type> var8, @Nullable Map<String, String> var9, @Nullable String var10, @Nullable ChildFilter var11, boolean var12);

    public Flux<Execution> findAllAsync(@Nullable String var1);

    public Execution delete(Execution var1);

    public Integer purge(Execution var1);

    public Integer purge(List<Execution> var1);

    public List<DailyExecutionStatistics> dailyStatisticsForAllTenants(@Nullable String var1, @Nullable String var2, @Nullable String var3, @Nullable ZonedDateTime var4, @Nullable ZonedDateTime var5, @Nullable DateUtils.GroupType var6);

    public List<DailyExecutionStatistics> dailyStatistics(@Nullable String var1, @Nullable String var2, @Nullable List<FlowScope> var3, @Nullable String var4, @Nullable String var5, @Nullable ZonedDateTime var6, @Nullable ZonedDateTime var7, @Nullable DateUtils.GroupType var8, List<State.Type> var9);

    public List<ExecutionCount> executionCounts(@Nullable String var1, @Nullable List<Flow> var2, @Nullable List<State.Type> var3, @Nullable ZonedDateTime var4, @Nullable ZonedDateTime var5, @Nullable List<String> var6);

    @Override
    public Execution save(Execution var1);

    public Execution update(Execution var1);

    default public Function<String, String> sortMapping() throws IllegalArgumentException {
        return s -> s;
    }

    public List<Execution> lastExecutions(String var1, @Nullable List<FlowFilter> var2);

    public static enum ChildFilter {
        CHILD,
        MAIN;

    }

    public static class FlowFilter {
        @NotNull
        private String namespace;
        @NotNull
        private String id;

        @Generated
        protected FlowFilter(FlowFilterBuilder<?, ?> b) {
            this.namespace = b.namespace;
            this.id = b.id;
        }

        @Generated
        public static FlowFilterBuilder<?, ?> builder() {
            return new FlowFilterBuilderImpl();
        }

        @Generated
        public String getNamespace() {
            return this.namespace;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public FlowFilter() {
        }

        @Generated
        public static abstract class FlowFilterBuilder<C extends FlowFilter, B extends FlowFilterBuilder<C, B>> {
            @Generated
            private String namespace;
            @Generated
            private String id;

            @Generated
            public B namespace(String namespace) {
                this.namespace = namespace;
                return this.self();
            }

            @Generated
            public B id(String id) {
                this.id = id;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "ExecutionRepositoryInterface.FlowFilter.FlowFilterBuilder(namespace=" + this.namespace + ", id=" + this.id + ")";
            }
        }

        @Generated
        private static final class FlowFilterBuilderImpl
        extends FlowFilterBuilder<FlowFilter, FlowFilterBuilderImpl> {
            @Generated
            private FlowFilterBuilderImpl() {
            }

            @Override
            @Generated
            protected FlowFilterBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public FlowFilter build() {
                return new FlowFilter(this);
            }
        }
    }
}

