/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.Label;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.ExecutionTrigger;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.executions.TaskRunAttempt;
import io.kestra.core.models.executions.Variables;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.FlowWithException;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.ExecutableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.repositories.ExecutionRepositoryInterface;
import io.kestra.core.runners.DefaultRunContext;
import io.kestra.core.runners.FlowInputOutput;
import io.kestra.core.runners.FlowMetaStoreInterface;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.SubflowExecution;
import io.kestra.core.runners.SubflowExecutionResult;
import io.kestra.core.services.ExecutionService;
import io.kestra.core.storages.Storage;
import io.kestra.core.trace.Tracer;
import io.kestra.core.trace.TracerFactory;
import io.kestra.core.trace.propagation.ExecutionTextMapSetter;
import io.kestra.core.utils.ListUtils;
import io.kestra.core.utils.MapUtils;
import io.kestra.core.utils.Rethrow;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.stream.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutableUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecutableUtils.class);
    public static final String TASK_VARIABLE_ITERATIONS = "iterations";
    public static final String TASK_VARIABLE_NUMBER_OF_BATCHES = "numberOfBatches";
    public static final String TASK_VARIABLE_SUBFLOW_OUTPUTS_BASE_URI = "subflowOutputsBaseUri";

    private ExecutableUtils() {
    }

    public static State.Type guessState(Execution execution, boolean transmitFailed, boolean allowedFailure, boolean allowWarning) {
        if (transmitFailed && (execution.getState().isFailed() || execution.getState().isPaused() || execution.getState().getCurrent() == State.Type.KILLED || execution.getState().getCurrent() == State.Type.WARNING)) {
            State.Type finalState = allowedFailure && execution.getState().isFailed() ? State.Type.WARNING : execution.getState().getCurrent();
            return finalState.equals((Object)State.Type.WARNING) && allowWarning ? State.Type.SUCCESS : finalState;
        }
        return State.Type.SUCCESS;
    }

    public static SubflowExecutionResult subflowExecutionResult(TaskRun parentTaskrun, Execution execution) {
        ArrayList<TaskRunAttempt> attempts = parentTaskrun.getAttempts() == null ? new ArrayList<TaskRunAttempt>() : new ArrayList<TaskRunAttempt>(parentTaskrun.getAttempts());
        attempts.add(TaskRunAttempt.builder().state(parentTaskrun.getState()).build());
        return SubflowExecutionResult.builder().executionId(execution.getId()).state(parentTaskrun.getState().getCurrent()).parentTaskRun(parentTaskrun.withAttempts(attempts)).build();
    }

    public static <T extends Task> Optional<SubflowExecution<?>> subflowExecution(RunContext runContext, FlowMetaStoreInterface flowExecutorInterface, Execution currentExecution, Flow currentFlow, T currentTask, TaskRun currentTaskRun, Map<String, Object> inputs, List<Label> labels, boolean inheritLabels, Property<ZonedDateTime> scheduleDate) throws IllegalVariableEvaluationException {
        Optional<TextMapPropagator> propagator = ((DefaultRunContext)runContext).getApplicationContext().findBean(OpenTelemetry.class).map(OpenTelemetry::getPropagators).map(ContextPropagators::getTextMapPropagator);
        TracerFactory tracerFactory = (TracerFactory)((DefaultRunContext)runContext).getApplicationContext().getBean(TracerFactory.class);
        Tracer tracer = tracerFactory.getTracer(currentTask.getClass(), "EXECUTOR");
        return tracer.inNewContext(currentExecution, currentTask.getType(), Tracer.throwCallable(() -> {
            ArrayList<Label> newLabels;
            if (currentExecution.getLabels() != null && currentExecution.getLabels().contains(new Label("system.restarted", "true")) && ((ExecutableTask)((Object)currentTask)).getRestartBehavior() == ExecutableTask.RestartBehavior.RETRY_FAILED) {
                List childExecutions;
                ExecutionRepositoryInterface executionRepository = (ExecutionRepositoryInterface)((DefaultRunContext)runContext).getApplicationContext().getBean(ExecutionRepositoryInterface.class);
                Optional<Object> existingSubflowExecution = Optional.empty();
                if (currentTaskRun.getOutputs() != null && currentTaskRun.getOutputs().containsKey("executionId")) {
                    existingSubflowExecution = executionRepository.findById(currentExecution.getTenantId(), (String)currentTaskRun.getOutputs().get("executionId"));
                }
                if (existingSubflowExecution.isEmpty() && (childExecutions = (List)executionRepository.findAllByTriggerExecutionId(currentExecution.getTenantId(), currentExecution.getId()).filter(e -> e.getNamespace().equals(((ExecutableTask)((Object)currentTask)).subflowId().namespace()) && e.getFlowId().equals(((ExecutableTask)((Object)currentTask)).subflowId().flowId()) && e.getTrigger().getId().equals(currentTask.getId())).filter(e -> Objects.equals(e.getTrigger().getVariables().get("taskRunId"), currentTaskRun.getId()) && Objects.equals(e.getTrigger().getVariables().get("taskRunValue"), currentTaskRun.getValue()) && Objects.equals(e.getTrigger().getVariables().get("taskRunIteration"), currentTaskRun.getIteration())).collectList().block()) != null && childExecutions.size() == 1) {
                    existingSubflowExecution = Optional.of((Execution)childExecutions.getFirst());
                }
                if (existingSubflowExecution.isPresent()) {
                    Execution subflowExecution = (Execution)existingSubflowExecution.get();
                    if (!subflowExecution.getState().isFailed()) {
                        return Optional.empty();
                    }
                    ExecutionService executionService = (ExecutionService)((DefaultRunContext)runContext).getApplicationContext().getBean(ExecutionService.class);
                    try {
                        Execution restarted = executionService.restart(subflowExecution, null);
                        propagator.ifPresent(pg -> pg.inject(Context.current(), (Object)restarted, (TextMapSetter)ExecutionTextMapSetter.INSTANCE));
                        return Optional.of(SubflowExecution.builder().parentTask(currentTask).parentTaskRun(currentTaskRun.withState(State.Type.RUNNING)).execution(restarted).build());
                    }
                    catch (Exception e2) {
                        throw new RuntimeException(e2);
                    }
                }
            }
            String subflowNamespace = runContext.render(((ExecutableTask)((Object)currentTask)).subflowId().namespace());
            String subflowId = runContext.render(((ExecutableTask)((Object)currentTask)).subflowId().flowId());
            Optional<Integer> subflowRevision = ((ExecutableTask)((Object)currentTask)).subflowId().revision();
            FlowInterface flow = flowExecutorInterface.findByIdFromTask(currentExecution.getTenantId(), subflowNamespace, subflowId, subflowRevision, currentExecution.getTenantId(), currentFlow.getNamespace(), currentFlow.getId()).orElseThrow(() -> {
                String msg = "Unable to find flow '" + subflowNamespace + "'.'" + subflowId + "' with revision '" + String.valueOf(subflowRevision.orElse(0)) + "'";
                runContext.logger().error(msg);
                return new IllegalStateException(msg);
            });
            if (flow.isDisabled()) {
                String msg = "Cannot execute a flow which is disabled";
                runContext.logger().error(msg);
                throw new IllegalStateException(msg);
            }
            if (flow instanceof FlowWithException) {
                FlowWithException fwe = (FlowWithException)flow;
                String msg = "Cannot execute an invalid flow: " + fwe.getException();
                runContext.logger().error(msg);
                throw new IllegalStateException(msg);
            }
            ArrayList<Label> arrayList = newLabels = inheritLabels ? new ArrayList<Label>(ExecutableUtils.filterLabels(currentExecution.getLabels(), flow)) : new ArrayList<Label>(ExecutableUtils.systemLabels(currentExecution));
            if (labels != null) {
                labels.forEach(Rethrow.throwConsumer(label -> newLabels.add(new Label(runContext.render(label.key()), runContext.render(label.value())))));
            }
            ImmutableMap.Builder variables = ImmutableMap.builder().putAll(Map.of("executionId", currentExecution.getId(), "namespace", currentFlow.getNamespace(), "flowId", currentFlow.getId(), "flowRevision", currentFlow.getRevision(), "taskRunId", currentTaskRun.getId(), "taskId", currentTaskRun.getTaskId()));
            if (currentTaskRun.getOutputs() != null) {
                variables.put((Object)"taskRunOutputs", (Object)currentTaskRun.getOutputs());
            }
            if (currentTaskRun.getValue() != null) {
                variables.put((Object)"taskRunValue", (Object)currentTaskRun.getValue());
            }
            if (currentTaskRun.getIteration() != null) {
                variables.put((Object)"taskRunIteration", (Object)currentTaskRun.getIteration());
            }
            FlowInputOutput flowInputOutput = (FlowInputOutput)((DefaultRunContext)runContext).getApplicationContext().getBean(FlowInputOutput.class);
            Instant scheduleOnDate = runContext.render(scheduleDate).as(ZonedDateTime.class).map(date -> date.toInstant()).orElse(null);
            Execution execution = Execution.newExecution(flow, (f, e) -> flowInputOutput.readExecutionInputs((FlowInterface)f, (Execution)e, inputs), newLabels, Optional.empty()).withTrigger(ExecutionTrigger.builder().id(currentTask.getId()).type(currentTask.getType()).variables((Map<String, Object>)variables.build()).build()).withScheduleDate(scheduleOnDate);
            if (execution.getInputs().size() < inputs.size()) {
                Map<String, Object> resolvedInputs = execution.getInputs();
                for (String inputKey : inputs.keySet()) {
                    if (resolvedInputs.containsKey(inputKey)) continue;
                    runContext.logger().warn("Input {} was provided by parent execution {} for subflow {}.{} but isn't declared at the subflow inputs", new Object[]{inputKey, currentExecution.getId(), ((ExecutableTask)((Object)currentTask)).subflowId().namespace(), ((ExecutableTask)((Object)currentTask)).subflowId().flowId()});
                }
            }
            propagator.ifPresent(pg -> pg.inject(Context.current(), (Object)execution, (TextMapSetter)ExecutionTextMapSetter.INSTANCE));
            return Optional.of(SubflowExecution.builder().parentTask(currentTask).parentTaskRun(currentTaskRun.withState(State.Type.RUNNING)).execution(execution).build());
        }));
    }

    private static List<Label> filterLabels(List<Label> labels, FlowInterface flow) {
        if (ListUtils.isEmpty(flow.getLabels())) {
            return labels;
        }
        return labels.stream().filter(label -> flow.getLabels().stream().noneMatch(flowLabel -> flowLabel.key().equals(label.key()))).toList();
    }

    private static List<Label> systemLabels(Execution execution) {
        return Streams.of(execution.getLabels()).filter(label -> label.key().startsWith("system.")).toList();
    }

    public static TaskRun manageIterations(Storage storage, TaskRun taskRun, Execution execution, boolean transmitFailed, boolean allowFailure, boolean allowWarning) throws InternalException {
        int terminatedIterations;
        Integer numberOfBatches = (Integer)taskRun.getOutputs().get(TASK_VARIABLE_NUMBER_OF_BATCHES);
        TaskRun previousTaskRun = execution.findTaskRunByTaskRunId(taskRun.getId());
        if (previousTaskRun == null) {
            throw new IllegalStateException("Should never happen");
        }
        State.Type currentState = taskRun.getState().getCurrent();
        Optional previousState = taskRun.getState().getHistories().size() > 1 ? Optional.of(taskRun.getState().getHistories().get(taskRun.getState().getHistories().size() - 2).getState()) : Optional.empty();
        HashMap<String, Integer> iterations = !MapUtils.isEmpty(previousTaskRun.getOutputs()) ? (Map)previousTaskRun.getOutputs().get(TASK_VARIABLE_ITERATIONS) : new HashMap<String, Integer>();
        int currentStateIteration = iterations.getOrDefault(currentState.toString(), 0);
        iterations.put(currentState.toString(), currentStateIteration + 1);
        if (previousState.isPresent() && previousState.get() != currentState) {
            int previousStateIterations = iterations.getOrDefault(((State.Type)((Object)previousState.get())).toString(), numberOfBatches);
            iterations.put(((State.Type)((Object)previousState.get())).toString(), previousStateIterations - 1);
            if (previousState.get() == State.Type.RESTARTED) {
                iterations.put(State.Type.FAILED.toString(), 0);
            }
        }
        if ((terminatedIterations = iterations.getOrDefault(State.Type.SUCCESS.toString(), 0) + iterations.getOrDefault(State.Type.FAILED.toString(), 0) + iterations.getOrDefault(State.Type.KILLED.toString(), 0) + iterations.getOrDefault(State.Type.WARNING.toString(), 0) + iterations.getOrDefault(State.Type.CANCELLED.toString(), 0)) == numberOfBatches) {
            State.Type state = transmitFailed ? ExecutableUtils.findTerminalState(iterations, allowFailure, allowWarning) : State.Type.SUCCESS;
            HashMap<String, Object> outputs = new HashMap<String, Object>();
            outputs.put(TASK_VARIABLE_ITERATIONS, iterations);
            outputs.put(TASK_VARIABLE_NUMBER_OF_BATCHES, numberOfBatches);
            outputs.put(TASK_VARIABLE_SUBFLOW_OUTPUTS_BASE_URI, storage.getContextBaseURI().getPath());
            return previousTaskRun.withIteration(taskRun.getIteration()).withOutputs(Variables.inMemory(outputs)).withAttempts(Collections.singletonList(TaskRunAttempt.builder().state(new State().withState(state)).build())).withState(state);
        }
        return previousTaskRun.withIteration(taskRun.getIteration()).withOutputs(Variables.inMemory(Map.of(TASK_VARIABLE_ITERATIONS, iterations, TASK_VARIABLE_NUMBER_OF_BATCHES, numberOfBatches)));
    }

    private static State.Type findTerminalState(Map<String, Integer> iterations, boolean allowFailure, boolean allowWarning) {
        if (iterations.getOrDefault(State.Type.FAILED.toString(), 0) > 0) {
            return allowFailure ? (allowWarning ? State.Type.SUCCESS : State.Type.WARNING) : State.Type.FAILED;
        }
        if (iterations.getOrDefault(State.Type.KILLED.toString(), 0) > 0) {
            return State.Type.KILLED;
        }
        if (iterations.getOrDefault(State.Type.WARNING.toString(), 0) > 0) {
            if (allowWarning) {
                return State.Type.SUCCESS;
            }
            return State.Type.WARNING;
        }
        return State.Type.SUCCESS;
    }

    public static SubflowExecutionResult subflowExecutionResultFromChildExecution(RunContext runContext, FlowInterface flow, Execution execution, ExecutableTask<?> executableTask, TaskRun taskRun) {
        try {
            return executableTask.createSubflowExecutionResult(runContext, taskRun, flow, execution).orElse(null);
        }
        catch (Exception e) {
            log.error("Unable to create the Subflow Execution Result", (Throwable)e);
            return SubflowExecutionResult.builder().executionId(execution.getId()).state(State.Type.FAILED).parentTaskRun(taskRun.withState(State.Type.FAILED).withAttempts(List.of(TaskRunAttempt.builder().state(new State().withState(State.Type.FAILED)).build()))).build();
        }
    }

    public static boolean isSubflow(Execution execution) {
        return execution.getTrigger() != null && ("io.kestra.plugin.core.flow.Subflow".equals(execution.getTrigger().getType()) || "io.kestra.plugin.core.flow.ForEachItem$ForEachItemExecutable".equals(execution.getTrigger().getType()) || "io.kestra.core.tasks.flows.Subflow".equals(execution.getTrigger().getType()) || "io.kestra.core.tasks.flows.Flow".equals(execution.getTrigger().getType()) || "io.kestra.core.tasks.flows.ForEachItem$ForEachItemExecutable".equals(execution.getTrigger().getType()));
    }
}

