/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.ExecutionKilledExecution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.FlowWithException;
import io.kestra.core.models.flows.FlowWithSource;
import io.kestra.core.models.flows.State;
import io.kestra.core.runners.ExecutionDelay;
import io.kestra.core.runners.ExecutionResumed;
import io.kestra.core.runners.ExecutionRunning;
import io.kestra.core.runners.SubflowExecution;
import io.kestra.core.runners.SubflowExecutionEnd;
import io.kestra.core.runners.SubflowExecutionResult;
import io.kestra.core.runners.WorkerJob;
import io.kestra.core.runners.WorkerTask;
import io.kestra.core.runners.WorkerTaskResult;
import io.kestra.core.runners.WorkerTrigger;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class Executor {
    private Execution execution;
    private Exception exception;
    private final List<String> from = new ArrayList<String>();
    private Long offset;
    @JsonIgnore
    private boolean executionUpdated = false;
    private FlowWithSource flow;
    private final List<TaskRun> nexts = new ArrayList<TaskRun>();
    private final List<WorkerTask> workerTasks = new ArrayList<WorkerTask>();
    private final List<ExecutionDelay> executionDelays = new ArrayList<ExecutionDelay>();
    private WorkerTaskResult joinedWorkerTaskResult;
    private final List<SubflowExecution<?>> subflowExecutions = new ArrayList();
    private final List<SubflowExecutionResult> subflowExecutionResults = new ArrayList<SubflowExecutionResult>();
    private SubflowExecutionResult joinedSubflowExecutionResult;
    private ExecutionRunning executionRunning;
    private ExecutionResumed executionResumed;
    private ExecutionResumed joinedExecutionResumed;
    private final List<WorkerTrigger> workerTriggers = new ArrayList<WorkerTrigger>();
    private WorkerJob workerJobToResubmit;
    private State.Type originalState;
    private SubflowExecutionEnd subflowExecutionEnd;
    private SubflowExecutionEnd joinedSubflowExecutionEnd;
    private long seqId = 0L;
    private List<ExecutionKilledExecution> executionKilled;

    public Executor(Execution execution, Long offset) {
        this.execution = execution;
        this.offset = offset;
        this.originalState = execution.getState().getCurrent();
    }

    public Executor(Execution execution, Long offset, long seqId) {
        this.execution = execution;
        this.offset = offset;
        this.seqId = seqId;
        this.originalState = execution.getState().getCurrent();
    }

    public Executor(WorkerTaskResult workerTaskResult) {
        this.joinedWorkerTaskResult = workerTaskResult;
    }

    public Executor(SubflowExecutionResult subflowExecutionResult) {
        this.joinedSubflowExecutionResult = subflowExecutionResult;
    }

    public Executor(SubflowExecutionEnd subflowExecutionEnd) {
        this.joinedSubflowExecutionEnd = subflowExecutionEnd;
    }

    public Executor(WorkerJob workerJob) {
        this.workerJobToResubmit = workerJob;
    }

    public Executor(ExecutionResumed executionResumed) {
        this.joinedExecutionResumed = executionResumed;
    }

    public Executor(List<ExecutionKilledExecution> executionKilled) {
        this.executionKilled = executionKilled;
    }

    public Boolean canBeProcessed() {
        return this.getException() == null && this.getFlow() != null && !(this.getFlow() instanceof FlowWithException) && this.getFlow().getTasks() != null && !this.getExecution().isDeleted() && !this.getExecution().getState().isPaused() && !this.getExecution().getState().isBreakpoint() && !this.getExecution().getState().isQueued();
    }

    public Executor withFlow(FlowWithSource flow) {
        this.flow = flow;
        return this;
    }

    public Executor withExecution(Execution execution, String from) {
        this.execution = execution;
        this.from.add(from);
        this.executionUpdated = true;
        return this;
    }

    public Executor withException(Exception exception, String from) {
        this.exception = exception;
        this.from.add(from);
        return this;
    }

    public Executor withTaskRun(List<TaskRun> taskRuns, String from) {
        this.nexts.addAll(taskRuns);
        this.from.add(from);
        return this;
    }

    public Executor withWorkerTasks(List<WorkerTask> workerTasks, String from) {
        this.workerTasks.addAll(workerTasks);
        this.from.add(from);
        return this;
    }

    public Executor withWorkerTriggers(List<WorkerTrigger> workerTriggers, String from) {
        this.workerTriggers.addAll(workerTriggers);
        this.from.add(from);
        return this;
    }

    public Executor withWorkerTaskDelays(List<ExecutionDelay> executionDelays, String from) {
        this.executionDelays.addAll(executionDelays);
        this.from.add(from);
        return this;
    }

    public Executor withSubflowExecutions(List<SubflowExecution<?>> subflowExecutions, String from) {
        this.subflowExecutions.addAll(subflowExecutions);
        this.from.add(from);
        return this;
    }

    public Executor withSubflowExecutionResults(List<SubflowExecutionResult> subflowExecutionResults, String from) {
        this.subflowExecutionResults.addAll(subflowExecutionResults);
        this.from.add(from);
        return this;
    }

    public Executor withExecutionRunning(ExecutionRunning executionRunning) {
        this.executionRunning = executionRunning;
        return this;
    }

    public Executor withExecutionResumed(ExecutionResumed executionResumed) {
        this.executionResumed = executionResumed;
        return this;
    }

    public Executor withExecutionKilled(List<ExecutionKilledExecution> executionKilled) {
        this.executionKilled = executionKilled;
        return this;
    }

    public Executor withSubflowExecutionEnd(SubflowExecutionEnd subflowExecutionEnd) {
        this.subflowExecutionEnd = subflowExecutionEnd;
        return this;
    }

    public Executor serialize() {
        return new Executor(this.execution, this.offset, this.seqId);
    }

    public long incrementAndGetSeqId() {
        ++this.seqId;
        return this.seqId;
    }

    @Generated
    public Execution getExecution() {
        return this.execution;
    }

    @Generated
    public Exception getException() {
        return this.exception;
    }

    @Generated
    public List<String> getFrom() {
        return this.from;
    }

    @Generated
    public Long getOffset() {
        return this.offset;
    }

    @Generated
    public boolean isExecutionUpdated() {
        return this.executionUpdated;
    }

    @Generated
    public FlowWithSource getFlow() {
        return this.flow;
    }

    @Generated
    public List<TaskRun> getNexts() {
        return this.nexts;
    }

    @Generated
    public List<WorkerTask> getWorkerTasks() {
        return this.workerTasks;
    }

    @Generated
    public List<ExecutionDelay> getExecutionDelays() {
        return this.executionDelays;
    }

    @Generated
    public WorkerTaskResult getJoinedWorkerTaskResult() {
        return this.joinedWorkerTaskResult;
    }

    @Generated
    public List<SubflowExecution<?>> getSubflowExecutions() {
        return this.subflowExecutions;
    }

    @Generated
    public List<SubflowExecutionResult> getSubflowExecutionResults() {
        return this.subflowExecutionResults;
    }

    @Generated
    public SubflowExecutionResult getJoinedSubflowExecutionResult() {
        return this.joinedSubflowExecutionResult;
    }

    @Generated
    public ExecutionRunning getExecutionRunning() {
        return this.executionRunning;
    }

    @Generated
    public ExecutionResumed getExecutionResumed() {
        return this.executionResumed;
    }

    @Generated
    public ExecutionResumed getJoinedExecutionResumed() {
        return this.joinedExecutionResumed;
    }

    @Generated
    public List<WorkerTrigger> getWorkerTriggers() {
        return this.workerTriggers;
    }

    @Generated
    public WorkerJob getWorkerJobToResubmit() {
        return this.workerJobToResubmit;
    }

    @Generated
    public State.Type getOriginalState() {
        return this.originalState;
    }

    @Generated
    public SubflowExecutionEnd getSubflowExecutionEnd() {
        return this.subflowExecutionEnd;
    }

    @Generated
    public SubflowExecutionEnd getJoinedSubflowExecutionEnd() {
        return this.joinedSubflowExecutionEnd;
    }

    @Generated
    public long getSeqId() {
        return this.seqId;
    }

    @Generated
    public List<ExecutionKilledExecution> getExecutionKilled() {
        return this.executionKilled;
    }

    @ConstructorProperties(value={"execution", "exception", "offset", "executionUpdated", "flow", "joinedWorkerTaskResult", "joinedSubflowExecutionResult", "executionRunning", "executionResumed", "joinedExecutionResumed", "workerJobToResubmit", "originalState", "subflowExecutionEnd", "joinedSubflowExecutionEnd", "seqId", "executionKilled"})
    @Generated
    public Executor(Execution execution, Exception exception, Long offset, boolean executionUpdated, FlowWithSource flow, WorkerTaskResult joinedWorkerTaskResult, SubflowExecutionResult joinedSubflowExecutionResult, ExecutionRunning executionRunning, ExecutionResumed executionResumed, ExecutionResumed joinedExecutionResumed, WorkerJob workerJobToResubmit, State.Type originalState, SubflowExecutionEnd subflowExecutionEnd, SubflowExecutionEnd joinedSubflowExecutionEnd, long seqId, List<ExecutionKilledExecution> executionKilled) {
        this.execution = execution;
        this.exception = exception;
        this.offset = offset;
        this.executionUpdated = executionUpdated;
        this.flow = flow;
        this.joinedWorkerTaskResult = joinedWorkerTaskResult;
        this.joinedSubflowExecutionResult = joinedSubflowExecutionResult;
        this.executionRunning = executionRunning;
        this.executionResumed = executionResumed;
        this.joinedExecutionResumed = joinedExecutionResumed;
        this.workerJobToResubmit = workerJobToResubmit;
        this.originalState = originalState;
        this.subflowExecutionEnd = subflowExecutionEnd;
        this.joinedSubflowExecutionEnd = joinedSubflowExecutionEnd;
        this.seqId = seqId;
        this.executionKilled = executionKilled;
    }
}

