/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.models.property.URIFetcher;
import io.kestra.core.models.tasks.runners.PluginUtilsService;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.Rethrow;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public abstract class FilesService {
    public static Map<String, String> inputFiles(RunContext runContext, Object inputs) throws Exception {
        return FilesService.inputFiles(runContext, Collections.emptyMap(), inputs);
    }

    public static Map<String, String> inputFiles(RunContext runContext, Map<String, Object> additionalVars, Object inputs) throws Exception {
        Logger logger = runContext.logger();
        HashMap<String, String> inputFiles = new HashMap<String, String>(inputs == null ? Map.of() : PluginUtilsService.transformInputFiles(runContext, additionalVars, inputs));
        inputFiles.forEach(Rethrow.throwBiConsumer((fileName, input) -> {
            block15: {
                File file = new File(runContext.workingDir().path().toString(), runContext.render((String)fileName, additionalVars));
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                if (input == null) {
                    if (!file.createNewFile()) {
                        throw new RuntimeException("Unable to create the file: " + file.getName());
                    }
                } else {
                    if (URIFetcher.supports(input)) {
                        URIFetcher uri = URIFetcher.of(input);
                        try (BufferedInputStream is = new BufferedInputStream(uri.fetch(runContext), 32768);
                             FileOutputStream out = new FileOutputStream(file);){
                            IOUtils.copyLarge((InputStream)is, (OutputStream)out);
                            break block15;
                        }
                    }
                    Files.write(file.toPath(), input.getBytes(), new OpenOption[0]);
                }
            }
        }));
        if (logger.isTraceEnabled()) {
            logger.trace("Provided {} input(s).", (Object)inputFiles.size());
        }
        return inputFiles;
    }

    public static Map<String, URI> outputFiles(RunContext runContext, List<String> outputs) throws Exception {
        List<String> renderedOutputs = outputs != null ? runContext.render(outputs) : null;
        List<Path> allFilesMatching = runContext.workingDir().findAllFilesMatching(renderedOutputs);
        Map<String, URI> outputFiles = allFilesMatching.stream().map(Rethrow.throwFunction(path -> new AbstractMap.SimpleEntry<String, URI>(runContext.workingDir().path().relativize((Path)path).toString(), runContext.storage().putFile(path.toFile(), FilesService.resolveUniqueNameForFile(path))))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (runContext.logger().isTraceEnabled()) {
            runContext.logger().trace("Captured {} output file(s).", (Object)allFilesMatching.size());
        }
        return outputFiles;
    }

    private static String resolveUniqueNameForFile(Path path) {
        String filename = path.getFileName().toString().replace(' ', '+');
        return IdUtils.from(path.toString()) + "-" + filename;
    }
}

