/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.runners.LocalPath;
import io.kestra.core.runners.RunContext;
import io.micronaut.context.annotation.Value;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.List;

@Singleton
public class LocalPathFactory {
    private final List<String> globalAllowedPaths;

    @Inject
    public LocalPathFactory(@Value(value="${kestra.local-files.allowed-paths:}") List<String> globalAllowedPaths) {
        this.globalAllowedPaths = globalAllowedPaths;
    }

    public LocalPath createLocalPath(RunContext runContext) {
        return new RunContextLocalPath(this.globalAllowedPaths, runContext);
    }

    public LocalPath createLocalPath() {
        return new DefaultLocalPath(this.globalAllowedPaths);
    }

    static class RunContextLocalPath
    extends AbstractLocalPath {
        private final List<String> globalAllowedPaths;
        private final RunContext runContext;

        RunContextLocalPath(List<String> globalAllowedPaths, RunContext runContext) {
            this.globalAllowedPaths = globalAllowedPaths;
            this.runContext = runContext;
        }

        @Override
        protected Path checkPath(URI uri) throws IOException {
            Path workingDirectory = this.runContext.workingDir().path(true);
            Path path = Path.of(uri).toRealPath(new LinkOption[0]);
            if (!path.startsWith(workingDirectory)) {
                if (this.globalAllowedPaths.stream().noneMatch(path::startsWith)) {
                    List pluginAllowedPaths = this.runContext.pluginConfiguration("allowed-paths").orElse(Collections.emptyList());
                    if (pluginAllowedPaths.stream().noneMatch(path::startsWith)) {
                        throw new SecurityException("The path " + String.valueOf(path) + " is not authorized. Only files inside the working directory are allowed by default, other path must be allowed either globally inside the Kestra configuration using the `kestra.local-files.allowed-paths` property, or by plugin using the `allowed-paths` plugin configuration.");
                    }
                }
            }
            return path;
        }
    }

    static class DefaultLocalPath
    extends AbstractLocalPath {
        private final List<String> globalAllowedPaths;

        DefaultLocalPath(List<String> globalAllowedPaths) {
            this.globalAllowedPaths = globalAllowedPaths;
        }

        @Override
        protected Path checkPath(URI uri) throws IOException {
            Path path = Path.of(uri).toRealPath(new LinkOption[0]);
            if (this.globalAllowedPaths.stream().noneMatch(path::startsWith)) {
                throw new SecurityException("The path " + String.valueOf(path) + " is not authorized. Path must be allowed either globally inside the Kestra configuration using the `kestra.local-files.allowed-paths` property.");
            }
            return path;
        }
    }

    static abstract class AbstractLocalPath
    implements LocalPath {
        AbstractLocalPath() {
        }

        @Override
        public InputStream get(URI uri) throws IOException {
            if (!"file".equals(uri.getScheme())) {
                throw new IllegalArgumentException("The uri '" + String.valueOf(uri) + "' is not a valid file URI.");
            }
            Path path = this.checkPath(uri);
            return new FileInputStream(path.toFile());
        }

        @Override
        public boolean exists(URI uri) throws IOException {
            if (!"file".equals(uri.getScheme())) {
                throw new IllegalArgumentException("The uri '" + String.valueOf(uri) + "' is not a valid file URI.");
            }
            Path path = this.checkPath(uri);
            return Files.exists(path, new LinkOption[0]);
        }

        @Override
        public BasicFileAttributes getAttributes(URI uri) throws IOException {
            if (!"file".equals(uri.getScheme())) {
                throw new IllegalArgumentException("The uri '" + String.valueOf(uri) + "' is not a valid file URI.");
            }
            Path path = this.checkPath(uri);
            return Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        }

        protected abstract Path checkPath(URI var1) throws IOException;
    }
}

