/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.executions.AbstractMetricEntry;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.property.PropertyContext;
import io.kestra.core.runners.LocalPath;
import io.kestra.core.runners.RunContextProperty;
import io.kestra.core.runners.WorkerTaskResult;
import io.kestra.core.runners.WorkingDir;
import io.kestra.core.storages.StateStore;
import io.kestra.core.storages.Storage;
import io.kestra.core.storages.kv.KVStore;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;

public abstract class RunContext
implements PropertyContext {
    @JsonIgnore
    public abstract String getTriggerExecutionId();

    @JsonInclude
    public abstract Map<String, Object> getVariables();

    @JsonInclude
    public abstract List<String> getSecretInputs();

    @JsonInclude
    public abstract String getTraceParent();

    public abstract void setTraceParent(String var1);

    public abstract String render(String var1) throws IllegalVariableEvaluationException;

    public abstract Object renderTyped(String var1) throws IllegalVariableEvaluationException;

    @Override
    public abstract String render(String var1, Map<String, Object> var2) throws IllegalVariableEvaluationException;

    public abstract <T> RunContextProperty<T> render(Property<T> var1);

    public abstract List<String> render(List<String> var1) throws IllegalVariableEvaluationException;

    public abstract List<String> render(List<String> var1, Map<String, Object> var2) throws IllegalVariableEvaluationException;

    public abstract Set<String> render(Set<String> var1) throws IllegalVariableEvaluationException;

    public abstract Set<String> render(Set<String> var1, Map<String, Object> var2) throws IllegalVariableEvaluationException;

    public abstract Map<String, Object> render(Map<String, Object> var1) throws IllegalVariableEvaluationException;

    @Override
    public abstract Map<String, Object> render(Map<String, Object> var1, Map<String, Object> var2) throws IllegalVariableEvaluationException;

    public abstract Map<String, String> renderMap(Map<String, String> var1) throws IllegalVariableEvaluationException;

    public abstract Map<String, String> renderMap(Map<String, String> var1, Map<String, Object> var2) throws IllegalVariableEvaluationException;

    public abstract <T> void validate(T var1);

    public abstract String decrypt(String var1) throws GeneralSecurityException;

    public abstract String encrypt(String var1) throws GeneralSecurityException;

    public abstract Logger logger();

    public abstract URI logFileURI();

    @JsonIgnore
    public abstract URI getStorageOutputPrefix();

    public abstract Storage storage();

    public abstract List<AbstractMetricEntry<?>> metrics();

    public abstract <T> RunContext metric(AbstractMetricEntry<T> var1);

    public abstract void dynamicWorkerResult(List<WorkerTaskResult> var1);

    public abstract List<WorkerTaskResult> dynamicWorkerResults();

    public abstract WorkingDir workingDir();

    public abstract void cleanup();

    @Deprecated(forRemoval=true)
    public abstract String tenantId();

    public abstract FlowInfo flowInfo();

    public abstract <T> Optional<T> pluginConfiguration(String var1);

    public abstract Map<String, Object> pluginConfigurations();

    public abstract String version();

    public abstract KVStore namespaceKv(String var1);

    @Deprecated(since="1.1.0", forRemoval=true)
    public StateStore stateStore() {
        return new StateStore(this, true);
    }

    public abstract LocalPath localPath();

    public abstract boolean isInitialized();

    public record FlowInfo(String tenantId, String namespace, String id, Integer revision) {
    }
}

