/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble;

import io.pebbletemplates.pebble.error.PebbleException;
import io.pebbletemplates.pebble.template.EvaluationContext;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import java.util.List;
import java.util.Map;

public abstract class AbstractIndent {
    public List<String> getArgumentNames() {
        return List.of("amount", "prefix");
    }

    protected static String prefix(Map<String, Object> args) {
        if (args.containsKey("prefix")) {
            return (String)args.get("prefix");
        }
        return " ";
    }

    protected static String getLineSeparator(String input) {
        if (input == null) {
            return System.lineSeparator();
        }
        if (input.contains("\r\n")) {
            return "\r\n";
        }
        if (input.contains("\n\r")) {
            return "\n\r";
        }
        if (input.contains("\n")) {
            return "\n";
        }
        if (input.contains("\r")) {
            return "\r";
        }
        return System.lineSeparator();
    }

    protected Object abstractApply(Object input, Map<String, Object> args, PebbleTemplate self, EvaluationContext context, int lineNumber, String indentType) throws PebbleException {
        if (input == null) {
            return null;
        }
        if (input.toString().isEmpty()) {
            return input.toString();
        }
        if (!args.containsKey("amount")) {
            throw new PebbleException(null, String.format("The '%s' filter expects an integer as argument 'amount'.", indentType), Integer.valueOf(lineNumber), self.getName());
        }
        int amount = ((Long)args.get("amount")).intValue();
        if (amount < 0) {
            throw new PebbleException(null, String.format("The '%s' filter expects a positive integer >=0 as argument 'amount'.", indentType), Integer.valueOf(lineNumber), self.getName());
        }
        String prefix = AbstractIndent.prefix(args);
        String newLine = AbstractIndent.getLineSeparator(input.toString());
        if (indentType.equals("indent")) {
            return input.toString().replace(newLine, newLine + prefix.repeat(amount));
        }
        if (indentType.equals("nindent")) {
            return (newLine + String.valueOf(input)).replace(newLine, newLine + prefix.repeat(amount));
        }
        throw new PebbleException(null, String.format("Unknow indent type '%s'.", indentType), Integer.valueOf(lineNumber), self.getName());
    }
}

