/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble;

import io.kestra.core.runners.VariableRenderer;
import io.kestra.core.runners.pebble.ExtensionCustomizer;
import io.kestra.core.runners.pebble.PebbleLruCache;
import io.kestra.core.runners.pebble.functions.RenderingFunctionInterface;
import io.micronaut.context.ApplicationContext;
import io.micronaut.core.annotation.Nullable;
import io.pebbletemplates.pebble.PebbleEngine;
import io.pebbletemplates.pebble.cache.PebbleCache;
import io.pebbletemplates.pebble.extension.Extension;
import io.pebbletemplates.pebble.extension.Function;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Singleton
public class PebbleEngineFactory {
    private final ApplicationContext applicationContext;
    private final VariableRenderer.VariableConfiguration variableConfiguration;

    @Inject
    public PebbleEngineFactory(ApplicationContext applicationContext, @Nullable VariableRenderer.VariableConfiguration variableConfiguration) {
        this.applicationContext = applicationContext;
        this.variableConfiguration = variableConfiguration;
    }

    public PebbleEngine create() {
        PebbleEngine.Builder builder = this.newPebbleEngineBuilder();
        this.applicationContext.getBeansOfType(Extension.class).forEach(xva$0 -> builder.extension(new Extension[]{xva$0}));
        return builder.build();
    }

    public PebbleEngine createWithMaskedFunctions(VariableRenderer renderer, List<String> functionsToMask) {
        PebbleEngine.Builder builder = this.newPebbleEngineBuilder();
        this.applicationContext.getBeansOfType(Extension.class).stream().map(e -> functionsToMask.stream().anyMatch(fun -> e.getFunctions().containsKey(fun)) ? this.extensionWithMaskedFunctions(renderer, (Extension)e, functionsToMask) : e).forEach(xva$0 -> builder.extension(new Extension[]{xva$0}));
        return builder.build();
    }

    private PebbleEngine.Builder newPebbleEngineBuilder() {
        PebbleEngine.Builder builder = new PebbleEngine.Builder().registerExtensionCustomizer(ExtensionCustomizer::new).strictVariables(true).cacheActive(this.variableConfiguration.getCacheEnabled().booleanValue()).newLineTrimming(false).autoEscaping(false);
        if (this.variableConfiguration.getCacheEnabled().booleanValue()) {
            builder = builder.templateCache((PebbleCache)new PebbleLruCache(this.variableConfiguration.getCacheSize()));
        }
        return builder;
    }

    private Extension extensionWithMaskedFunctions(VariableRenderer renderer, Extension initialExtension, List<String> maskedFunctions) {
        return (Extension)Proxy.newProxyInstance(initialExtension.getClass().getClassLoader(), new Class[]{Extension.class}, (proxy, method, methodArgs) -> {
            if (method.getName().equals("getFunctions")) {
                return initialExtension.getFunctions().entrySet().stream().map(entry -> {
                    if (maskedFunctions.contains(entry.getKey())) {
                        return Map.entry((String)entry.getKey(), this.maskedFunctionProxy((Function)entry.getValue()));
                    }
                    if (RenderingFunctionInterface.class.isAssignableFrom(((Function)entry.getValue()).getClass())) {
                        return Map.entry((String)entry.getKey(), this.variableRendererProxy(renderer, (Function)entry.getValue()));
                    }
                    return entry;
                }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            }
            return method.invoke((Object)initialExtension, methodArgs);
        });
    }

    private Function variableRendererProxy(VariableRenderer renderer, Function initialFunction) {
        return (Function)Proxy.newProxyInstance(initialFunction.getClass().getClassLoader(), new Class[]{Function.class, RenderingFunctionInterface.class}, (functionProxy, functionMethod, functionArgs) -> {
            if (functionMethod.getName().equals("variableRenderer")) {
                return renderer;
            }
            return functionMethod.invoke((Object)initialFunction, functionArgs);
        });
    }

    private Function maskedFunctionProxy(Function initialFunction) {
        return (Function)Proxy.newProxyInstance(initialFunction.getClass().getClassLoader(), new Class[]{Function.class}, (functionProxy, functionMethod, functionArgs) -> {
            Object result;
            try {
                result = functionMethod.invoke((Object)initialFunction, functionArgs);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            if (functionMethod.getName().equals("execute")) {
                return "******";
            }
            return result;
        });
    }
}

