/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble;

import io.kestra.core.runners.pebble.OutputWriter;
import io.pebbletemplates.pebble.extension.writer.SpecializedWriter;
import java.io.IOException;
import java.util.Arrays;

public class TypedObjectWriter
extends OutputWriter
implements SpecializedWriter {
    private Object current;

    public void writeSpecialized(int i) {
        this.concatSpecialized(i);
    }

    public void writeSpecialized(long l) {
        this.concatSpecialized(l);
    }

    public void writeSpecialized(double d) {
        this.concatSpecialized(d);
    }

    public void writeSpecialized(float f) {
        this.concatSpecialized(Float.valueOf(f));
    }

    public void writeSpecialized(short s) {
        this.concatSpecialized(s);
    }

    public void writeSpecialized(byte b) {
        this.concatSpecialized(b);
    }

    public void writeSpecialized(char c) {
        this.concatSpecialized(Character.valueOf(c));
    }

    public void writeSpecialized(String s) {
        this.concatSpecialized(s);
    }

    private void concatSpecialized(Object o) {
        if (o == null) {
            return;
        }
        if (this.current == null) {
            this.current = o;
            return;
        }
        if (TypedObjectWriter.isConcatenableScalar(this.current) && TypedObjectWriter.isConcatenableScalar(o)) {
            this.current = this.current.toString() + String.valueOf(o);
            return;
        }
        throw new IllegalArgumentException("Cannot concat " + this.current.getClass().getName() + " with " + o.getClass().getName());
    }

    public void write(Object o) {
        block5: {
            if (o == null) {
                return;
            }
            if (this.current == null) {
                this.current = o;
                break block5;
            }
            if (TypedObjectWriter.isConcatenableScalar(o)) {
                super.write(o);
                break block5;
            }
            throw new IllegalArgumentException("Cannot concat " + this.current.getClass().getName() + " with " + o.getClass().getName());
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writeSpecialized(String.valueOf(Arrays.copyOfRange(cbuf, off, off + len)));
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Object output() {
        return this.current;
    }

    public static boolean isConcatenableScalar(Object obj) {
        if (obj == null) {
            return false;
        }
        Class<?> clazz = obj.getClass();
        return clazz == Boolean.class || clazz == Character.class || clazz == String.class || Number.class.isAssignableFrom(clazz);
    }
}

