/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.filters;

import io.kestra.core.runners.pebble.AbstractDate;
import io.pebbletemplates.pebble.error.PebbleException;
import io.pebbletemplates.pebble.extension.Filter;
import io.pebbletemplates.pebble.template.EvaluationContext;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;

public class DateAddFilter
extends AbstractDate
implements Filter {
    @Override
    public List<String> getArgumentNames() {
        return List.of("amount", "unit", "format", "timeZone", "existingFormat", "locale");
    }

    public Object apply(Object input, Map<String, Object> args, PebbleTemplate self, EvaluationContext context, int lineNumber) throws PebbleException {
        if (input == null) {
            return null;
        }
        Long amount = DateAddFilter.getAsLong(args.get("amount"), lineNumber, self);
        String unit = (String)args.get("unit");
        String timeZone = (String)args.get("timeZone");
        String existingFormat = (String)args.get("existingFormat");
        ZoneId zoneId = DateAddFilter.zoneId(timeZone);
        ZonedDateTime date = DateAddFilter.convert(input, zoneId, existingFormat);
        ZonedDateTime plus = date.plus(amount, ChronoUnit.valueOf(unit));
        return DateAddFilter.format(plus, args, context);
    }

    public static Long getAsLong(Object value, int lineNumber, PebbleTemplate self) {
        if (value instanceof Long) {
            Long longValue = (Long)value;
            return longValue;
        }
        if (value instanceof Integer) {
            Integer integerValue = (Integer)value;
            return integerValue.longValue();
        }
        if (value instanceof Number) {
            Number numberValue = (Number)value;
            return numberValue.longValue();
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            try {
                return Long.parseLong(stringValue);
            }
            catch (NumberFormatException e) {
                throw new PebbleException((Throwable)e, "%s can't be converted to long".formatted(stringValue), Integer.valueOf(lineNumber), self != null ? self.getName() : "Unknown");
            }
        }
        throw new PebbleException(null, "Incorrect %s format, must be a number".formatted(value), Integer.valueOf(lineNumber), self != null ? self.getName() : "Unknown");
    }
}

