/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.functions;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.http.HttpRequest;
import io.kestra.core.http.HttpResponse;
import io.kestra.core.http.client.HttpClient;
import io.kestra.core.http.client.HttpClientException;
import io.kestra.core.http.client.HttpClientResponseException;
import io.kestra.core.http.client.configurations.HttpConfiguration;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.serializers.JacksonMapper;
import io.micronaut.context.ApplicationContext;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.MediaType;
import io.micronaut.http.body.DefaultMessageBodyHandlerRegistry;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.simple.SimpleHttpHeaders;
import io.micronaut.http.uri.UriBuilder;
import io.pebbletemplates.pebble.error.PebbleException;
import io.pebbletemplates.pebble.extension.Function;
import io.pebbletemplates.pebble.template.EvaluationContext;
import io.pebbletemplates.pebble.template.EvaluationContextImpl;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;

@Singleton
public class HttpFunction<T>
implements Function {
    public static final String NAME = "http";
    private final MessageBodyWriter<T> FALLBACK_CONTENT_WRITER = (type, mediaType, object, outgoingHeaders, outputStream) -> {
        if (mediaType == MediaType.APPLICATION_YAML_TYPE || mediaType.equals((Object)MediaType.of((String)"application/yaml"))) {
            try {
                outputStream.write(JacksonMapper.ofYaml().writeValueAsString(object).getBytes(StandardCharsets.UTF_8));
                return;
            }
            catch (IOException e) {
                throw new PebbleException((Throwable)e, "Couldn't write the request body as YAML");
            }
        }
        throw new PebbleException((Throwable)new IllegalArgumentException("Unsupported content type: " + String.valueOf(mediaType)), "Unsupported content type ");
    };
    @Inject
    private ApplicationContext applicationContext;
    @Inject
    private DefaultMessageBodyHandlerRegistry defaultMessageBodyHandlerRegistry;

    public Object execute(Map<String, Object> args, PebbleTemplate self, EvaluationContext context, int lineNumber) {
        Object object;
        URI uriObject;
        this.throwIfMissingArgs(args, self, lineNumber);
        EvaluationContextImpl evaluationContext = (EvaluationContextImpl)context;
        Map pebbleVariables = evaluationContext.getScopeChain().getGlobalScopes().stream().flatMap(scope -> scope.getKeys().stream()).distinct().collect(HashMap::new, (m, k) -> m.put(k, context.getVariable(k)), HashMap::putAll);
        RunContextFactory runContextFactory = (RunContextFactory)this.applicationContext.getBean(RunContextFactory.class);
        RunContext runContext = runContextFactory.of(pebbleVariables);
        Object object2 = args.get("uri");
        URI uri = object2 instanceof URI ? (uriObject = (URI)object2) : URI.create(args.get("uri").toString());
        Map<String, Object> query = args.getOrDefault("query", Collections.emptyMap());
        String method = args.getOrDefault("method", "GET").toString().toUpperCase();
        String contentType = args.getOrDefault("contentType", "application/json").toString();
        String accept = args.getOrDefault("accept", "application/json").toString();
        HttpRequest.RequestBody body = null;
        Map headers = Optional.ofNullable((Map)args.get("headers")).map(this::singleValueToListForHeaders).orElse(new HashMap());
        headers.remove("Content-Type");
        headers.put("Accept", List.of(accept));
        if (args.containsKey("body")) {
            body = this.toRequestBody(args, self, lineNumber, contentType);
        }
        UriBuilder uriWithQueryBuilder = UriBuilder.of((URI)uri);
        query.forEach((x$0, xva$1) -> uriWithQueryBuilder.queryParam(x$0, new Object[]{xva$1}));
        HttpRequest httpRequest = HttpRequest.of(uriWithQueryBuilder.build(), method, body, headers);
        HttpConfiguration httpConfiguration = Optional.ofNullable(args.get("options")).map(o -> JacksonMapper.toMap(o, HttpConfiguration.class)).orElse(null);
        HttpClient httpClient = new HttpClient(runContext, httpConfiguration);
        try {
            HttpResponse<Object> response = httpClient.request(httpRequest, Object.class);
            object = response.getBody();
        }
        catch (Throwable response) {
            try {
                try {
                    httpClient.close();
                }
                catch (Throwable throwable) {
                    response.addSuppressed(throwable);
                }
                throw response;
            }
            catch (HttpClientResponseException e) {
                if (e.getResponse() != null) {
                    String msg = "Failed to execute HTTP Request, server respond with status " + e.getResponse().getStatus().getCode() + " : " + e.getResponse().getStatus().getReason();
                    throw new PebbleException((Throwable)((Object)e), msg, Integer.valueOf(lineNumber), self.getName());
                }
                throw new PebbleException((Throwable)((Object)e), "Failed to execute HTTP request ", Integer.valueOf(lineNumber), self.getName());
            }
            catch (IllegalVariableEvaluationException | HttpClientException | IOException e) {
                throw new PebbleException((Throwable)e, "Failed to execute HTTP request ", Integer.valueOf(lineNumber), self.getName());
            }
        }
        httpClient.close();
        return object;
    }

    private Map<String, List<String>> singleValueToListForHeaders(Map<String, Object> m) {
        return m.entrySet().stream().map(e -> {
            List<String> list;
            String string = (String)e.getKey();
            Object patt0$temp = e.getValue();
            if (patt0$temp instanceof String) {
                String valueStr = (String)patt0$temp;
                list = List.of(valueStr);
            } else {
                list = (List<String>)e.getValue();
            }
            return Map.entry(string, list);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private HttpRequest.RequestBody toRequestBody(Map<String, Object> args, PebbleTemplate self, int lineNumber, String contentType) {
        HttpRequest.RequestBody body;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Class<?> bodyClass = args.get("body").getClass();
        MessageBodyWriter<T> bodyWriter = this.defaultMessageBodyHandlerRegistry.findWriter(Argument.of(bodyClass), MediaType.of((String)contentType)).orElse(this.FALLBACK_CONTENT_WRITER);
        bodyWriter.writeTo(Argument.of(bodyClass), MediaType.of((String)contentType), args.get("body"), (MutableHeaders)new SimpleHttpHeaders(), (OutputStream)byteArrayOutputStream);
        try {
            body = HttpRequest.RequestBody.from((HttpEntity)new ByteArrayEntity(byteArrayOutputStream.toByteArray(), ContentType.create((String)contentType)));
        }
        catch (IOException e) {
            throw new PebbleException((Throwable)e, "Couldn't parse the request body", Integer.valueOf(lineNumber), self.getName());
        }
        return body;
    }

    private void throwIfMissingArgs(Map<String, Object> args, PebbleTemplate self, int lineNumber) {
        if (!args.containsKey("uri")) {
            throw new PebbleException(null, "The 'http' function expects an argument 'uri'.", Integer.valueOf(lineNumber), self.getName());
        }
    }

    public List<String> getArgumentNames() {
        return List.of("uri", "method", "query", "body", "contentType", "headers", "options", "accept");
    }
}

