/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.secret;

import io.kestra.core.models.QueryFilter;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.secret.SecretNotFoundException;
import io.micronaut.data.model.Pageable;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SecretService<META> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecretService.class);
    private static final String SECRET_PREFIX = "SECRET_";
    private Map<String, String> decodedSecrets;

    @PostConstruct
    private void postConstruct() {
        this.decode();
    }

    public void decode() {
        this.decodedSecrets = System.getenv().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(SECRET_PREFIX)).mapMulti((entry, consumer) -> {
            try {
                String value = ((String)entry.getValue()).replaceAll("\\R", "");
                consumer.accept(Map.entry((String)entry.getKey(), new String(Base64.getDecoder().decode(value))));
            }
            catch (Exception e) {
                log.error("Could not decode secret '{}', make sure it is Base64-encoded: {}", entry.getKey(), (Object)e.getMessage());
            }
        }).collect(Collectors.toMap(entry -> ((String)entry.getKey()).substring(SECRET_PREFIX.length()).toUpperCase(), Map.Entry::getValue));
    }

    public String findSecret(String tenantId, String namespace, String key) throws SecretNotFoundException, IOException {
        String secret = this.decodedSecrets.get(key.toUpperCase());
        if (secret == null) {
            throw new SecretNotFoundException("Cannot find secret for key '" + key + "'.");
        }
        return secret;
    }

    public ArrayListTotal<META> list(Pageable pageable, String tenantId, List<QueryFilter> filters) throws IOException {
        Predicate<String> queryPredicate = filters.stream().filter(filter -> filter.field().equals((Object)QueryFilter.Field.QUERY) && filter.value() != null).findFirst().map(filter -> {
            if (filter.operation().equals((Object)QueryFilter.Op.EQUALS)) {
                return s -> Strings.CI.contains((CharSequence)s, (CharSequence)((String)filter.value()));
            }
            if (filter.operation().equals((Object)QueryFilter.Op.NOT_EQUALS)) {
                return s -> !Strings.CI.contains((CharSequence)s, (CharSequence)((String)filter.value()));
            }
            throw new IllegalArgumentException("Unsupported operation for QUERY filter: " + String.valueOf((Object)filter.operation()));
        }).orElse(s -> true);
        return ArrayListTotal.of(pageable, this.decodedSecrets.keySet().stream().filter(queryPredicate).map(s -> s).toList());
    }

    public Map<String, Set<String>> inheritedSecrets(String tenantId, String namespace) throws IOException {
        return Map.of(namespace, this.decodedSecrets.keySet());
    }
}

