/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.serializers;

import com.amazon.ion.IonSystem;
import com.amazon.ion.system.IonSystemBuilder;
import com.amazon.ion.system.IonTextWriterBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.ion.IonObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.diff.JsonDiff;
import io.kestra.core.plugins.PluginModule;
import io.kestra.core.runners.RunContextModule;
import io.kestra.core.serializers.DurationDeserializer;
import io.kestra.core.serializers.ion.IonFactory;
import io.kestra.core.serializers.ion.IonModule;
import java.io.IOException;
import java.time.Duration;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.tuple.Pair;
import org.yaml.snakeyaml.LoaderOptions;

public final class JacksonMapper {
    public static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
    public static final TypeReference<List<Object>> LIST_TYPE_REFERENCE = new TypeReference<List<Object>>(){};
    public static final TypeReference<Object> OBJECT_TYPE_REFERENCE = new TypeReference<Object>(){};
    private static final ObjectMapper MAPPER;
    private static final ObjectMapper NON_STRICT_MAPPER;
    private static final ObjectMapper YAML_MAPPER;
    private static final ObjectMapper ION_MAPPER;

    private JacksonMapper() {
    }

    public static ObjectMapper ofJson() {
        return JacksonMapper.ofJson(true);
    }

    public static ObjectMapper ofJson(boolean strict) {
        return strict ? MAPPER : NON_STRICT_MAPPER;
    }

    public static ObjectMapper ofYaml() {
        return YAML_MAPPER;
    }

    public static Map<String, Object> toMap(Object object, ZoneId zoneId) {
        return (Map)MAPPER.copy().setTimeZone(TimeZone.getTimeZone(zoneId.getId())).convertValue(object, MAP_TYPE_REFERENCE);
    }

    public static Map<String, Object> toMap(Object object) {
        return (Map)MAPPER.convertValue(object, MAP_TYPE_REFERENCE);
    }

    public static <T> T toMap(Object map, Class<T> cls) {
        return (T)MAPPER.convertValue(map, cls);
    }

    public static Map<String, Object> toMap(String json) throws JsonProcessingException {
        return (Map)MAPPER.readValue(json, MAP_TYPE_REFERENCE);
    }

    public static List<Object> toList(String json) throws JsonProcessingException {
        return (List)MAPPER.readValue(json, LIST_TYPE_REFERENCE);
    }

    public static List<String> toList(Object object) {
        return (List)MAPPER.convertValue(object, (TypeReference)new TypeReference<List<String>>(){});
    }

    public static Object toObject(String json) throws JsonProcessingException {
        return MAPPER.readValue(json, OBJECT_TYPE_REFERENCE);
    }

    public static <T> T cast(Object object, Class<T> cls) throws JsonProcessingException {
        return (T)MAPPER.readValue(MAPPER.writeValueAsString(object), cls);
    }

    public static <T> String log(T Object2) {
        try {
            return YAML_MAPPER.writeValueAsString(Object2);
        }
        catch (JsonProcessingException ignored) {
            return "Failed to log " + String.valueOf(Object2.getClass());
        }
    }

    public static ObjectMapper ofIon() {
        return ION_MAPPER;
    }

    private static ObjectMapper configure(ObjectMapper mapper) {
        SimpleModule durationDeserialization = new SimpleModule();
        durationDeserialization.addDeserializer(Duration.class, (JsonDeserializer)new DurationDeserializer());
        return mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).setDefaultPropertyInclusion(JsonInclude.Include.NON_NULL).registerModule((Module)new JavaTimeModule()).registerModule((Module)new Jdk8Module()).registerModule((Module)new ParameterNamesModule()).registerModules(new Module[]{new GuavaModule()}).registerModule((Module)new PluginModule()).registerModule((Module)new RunContextModule()).registerModule((Module)durationDeserialization).setTimeZone(TimeZone.getDefault());
    }

    private static ObjectMapper createIonObjectMapper() {
        return JacksonMapper.configure((ObjectMapper)new IonObjectMapper((com.fasterxml.jackson.dataformat.ion.IonFactory)new IonFactory(JacksonMapper.createIonSystem()))).setDefaultPropertyInclusion(JsonInclude.Include.ALWAYS).registerModule((Module)new IonModule());
    }

    private static IonSystem createIonSystem() {
        return IonSystemBuilder.standard().withIonTextWriterBuilder(IonTextWriterBuilder.standard().withWriteTopLevelValuesOnNewLines(true)).build();
    }

    public static Pair<JsonNode, JsonNode> getBiDirectionalDiffs(Object before, Object after) {
        JsonNode beforeNode = MAPPER.valueToTree(before);
        JsonNode afterNode = MAPPER.valueToTree(after);
        JsonNode patch = JsonDiff.asJson((JsonNode)beforeNode, (JsonNode)afterNode);
        JsonNode revert = JsonDiff.asJson((JsonNode)afterNode, (JsonNode)beforeNode);
        return Pair.of((Object)patch, (Object)revert);
    }

    public static JsonNode applyPatchesOnJsonNode(JsonNode jsonObject, List<JsonNode> patches) {
        for (JsonNode patch : patches) {
            try {
                if (patch.findValue("value") == null && !patch.isEmpty()) {
                    ((ObjectNode)patch.get(0)).set("value", null);
                }
                jsonObject = JsonPatch.fromJson((JsonNode)patch).apply(jsonObject);
            }
            catch (JsonPatchException | IOException e) {
                throw new RuntimeException(e);
            }
        }
        return jsonObject;
    }

    static {
        StreamReadConstraints.overrideDefaultStreamReadConstraints((StreamReadConstraints)StreamReadConstraints.builder().maxNameLength(20000000).build());
        MAPPER = JacksonMapper.configure(new ObjectMapper());
        NON_STRICT_MAPPER = MAPPER.copy().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        YAML_MAPPER = JacksonMapper.configure(new ObjectMapper((JsonFactory)YAMLFactory.builder().loaderOptions(new LoaderOptions()).configure(YAMLGenerator.Feature.MINIMIZE_QUOTES, true).configure(YAMLGenerator.Feature.WRITE_DOC_START_MARKER, false).configure(YAMLGenerator.Feature.USE_NATIVE_TYPE_ID, false).configure(YAMLGenerator.Feature.SPLIT_LINES, false).build()));
        ION_MAPPER = JacksonMapper.createIonObjectMapper();
    }
}

