/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.server;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.kestra.core.server.Metric;
import io.kestra.core.server.ServiceType;
import io.kestra.core.utils.Enums;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public interface Service
extends AutoCloseable {
    public String getId();

    public ServiceType getType();

    public ServiceState getState();

    default public Set<Metric> getMetrics() {
        return Set.of();
    }

    default public void skipGracefulTermination(boolean skipGracefulTermination) {
    }

    default public <T extends Service> T unwrap() {
        return (T)this;
    }

    @Override
    default public void close() {
    }

    public static enum ServiceState {
        CREATED(1, 2, 3, 4, 9),
        RUNNING(2, 3, 4, 9),
        ERROR(4),
        DISCONNECTED(4, 7),
        TERMINATING(5, 6, 7),
        TERMINATED_GRACEFULLY(7),
        TERMINATED_FORCED(7),
        NOT_RUNNING(8),
        INACTIVE(new Integer[0]),
        MAINTENANCE(1, 2, 3, 4);

        private final Set<Integer> validTransitions = new HashSet<Integer>();

        private ServiceState(Integer ... validTransitions) {
            this.validTransitions.addAll(Arrays.asList(validTransitions));
        }

        @JsonCreator
        public static ServiceState fromString(String value) {
            try {
                return Enums.getForNameIgnoreCase(value, ServiceState.class, Map.of("EMPTY", INACTIVE));
            }
            catch (IllegalArgumentException e) {
                return INACTIVE;
            }
        }

        public boolean isValidTransition(ServiceState newState) {
            return this.validTransitions.contains(newState.ordinal()) || this.equals((Object)newState);
        }

        public boolean isRunning() {
            return ServiceState.allRunningStates().contains((Object)this);
        }

        public boolean isDisconnectedOrTerminating() {
            return this.equals((Object)TERMINATING) || this.equals((Object)DISCONNECTED);
        }

        public boolean hasCompletedTermination() {
            return this.equals((Object)TERMINATED_GRACEFULLY) || this.equals((Object)TERMINATED_FORCED) || this.equals((Object)NOT_RUNNING) || this.equals((Object)INACTIVE);
        }

        public static Set<ServiceState> allRunningStates() {
            return Set.of(CREATED, RUNNING, MAINTENANCE);
        }

        public static Set<ServiceState> allNonRunningStates() {
            return Enums.allExcept(ServiceState.class, ServiceState.allRunningStates());
        }
    }
}

