/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.server;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.kestra.core.models.HasUID;
import io.kestra.core.server.Metric;
import io.kestra.core.server.ServerConfig;
import io.kestra.core.server.ServerInstance;
import io.kestra.core.server.Service;
import io.kestra.core.server.ServiceType;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@JsonInclude
public record ServiceInstance(@JsonProperty(value="id") String uid, ServiceType type, Service.ServiceState state, ServerInstance server, Instant createdAt, Instant updatedAt, List<TimestampedEvent> events, ServerConfig config, Map<String, Object> props, Set<Metric> metrics, long seqId) implements HasUID
{
    private static final String SERVICE_STATE_UPDATED_EVENT_TYPE = "service.state.updated";

    public ServiceInstance(String id, ServiceType type, Service.ServiceState state, ServerInstance server, Instant createdAt, Instant updatedAt, List<TimestampedEvent> events, ServerConfig config, Map<String, Object> props, Set<Metric> metrics) {
        this(id, type, state, server, createdAt, updatedAt, events, config, props, metrics, 0L);
    }

    public static ServiceInstance create(String id, ServiceType type, ServerInstance server, Instant createdAt, Instant updatedAt, ServerConfig config, Map<String, Object> props, Set<Metric> metrics) {
        return new ServiceInstance(id, type, Service.ServiceState.CREATED, server, createdAt, updatedAt, List.of(new TimestampedEvent(updatedAt, "Service connected.", SERVICE_STATE_UPDATED_EVENT_TYPE, Service.ServiceState.CREATED)), config, props, metrics);
    }

    public boolean is(ServiceType type) {
        return this.type.equals((Object)type);
    }

    public boolean is(Service.ServiceState state) {
        return this.state.equals((Object)state);
    }

    public ServiceInstance server(ServerInstance server) {
        return new ServiceInstance(this.uid, this.type, this.state, server, this.createdAt, this.updatedAt, this.events, this.config, this.props, this.metrics, this.seqId);
    }

    public ServiceInstance metrics(Set<Metric> metrics) {
        return new ServiceInstance(this.uid, this.type, this.state, this.server, this.createdAt, this.updatedAt, this.events, this.config, this.props, metrics, this.seqId);
    }

    public ServiceInstance state(Service.ServiceState newState, Instant updatedAt) {
        return this.state(newState, updatedAt, null);
    }

    public ServiceInstance state(Service.ServiceState newState, Instant updatedAt, String reason) {
        if (reason == null && !this.state.equals((Object)newState)) {
            reason = String.format("Service transitioned to the '%s' state.", new Object[]{newState});
        }
        ArrayList<TimestampedEvent> events = Optional.ofNullable(this.events).orElse(new ArrayList());
        if (reason != null) {
            events = new ArrayList<TimestampedEvent>(events);
            events.add(new TimestampedEvent(updatedAt, reason, SERVICE_STATE_UPDATED_EVENT_TYPE, newState));
        }
        long nextSeqId = this.seqId + 1L;
        return new ServiceInstance(this.uid, this.type, newState, this.server, this.createdAt, updatedAt, events, this.config, this.props, this.metrics, nextSeqId);
    }

    public boolean isSessionTimeoutElapsed(Instant now) {
        Duration timeout = this.config.liveness().timeout();
        return this.state.isRunning() && this.updatedAt().plus(timeout).isBefore(now);
    }

    public boolean isTerminationGracePeriodElapsed(Instant now) {
        Duration terminationGracePeriod = this.config.terminationGracePeriod();
        return this.updatedAt().plus(terminationGracePeriod).isBefore(now);
    }

    public static Map<String, List<ServiceInstance>> groupByProperty(Collection<ServiceInstance> instances, String property) {
        return instances.stream().filter(it -> Optional.ofNullable(it.props()).map(map -> map.get(property)).isPresent()).collect(Collectors.groupingBy(it -> (String)it.props().get(property)));
    }

    public record TimestampedEvent(Instant ts, String value, String type, Service.ServiceState state) {
    }
}

