/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.services;

import com.cronutils.utils.VisibleForTesting;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.conditions.ScheduleCondition;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.tasks.ResolvedTask;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.multipleflows.MultipleCondition;
import io.kestra.core.models.triggers.multipleflows.MultipleConditionStorageInterface;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.utils.Rethrow;
import io.micronaut.core.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Singleton
public class ConditionService {
    @Inject
    private RunContextFactory runContextFactory;

    @VisibleForTesting
    public boolean isValid(Condition condition, FlowInterface flow, @Nullable Execution execution, MultipleConditionStorageInterface multipleConditionStorage) {
        ConditionContext conditionContext = this.conditionContext(this.runContextFactory.of(flow, execution), flow, execution, multipleConditionStorage);
        return this.valid(flow, Collections.singletonList(condition), conditionContext);
    }

    public boolean isValid(Condition condition, FlowInterface flow, @Nullable Execution execution) {
        return this.isValid(condition, flow, execution, null);
    }

    private void logException(FlowInterface flow, Object condition, ConditionContext conditionContext, Exception e) {
        conditionContext.getRunContext().logger().warn("[namespace: {}] [flow: {}] [condition: {}] Evaluate Condition Failed with error '{}'", new Object[]{flow.getNamespace(), flow.getId(), condition.toString(), e.getMessage(), e});
    }

    public boolean isValid(Flow flow, AbstractTrigger trigger, ConditionContext conditionContext) {
        ArrayList<Condition> conditions = trigger.getConditions() == null ? new ArrayList() : trigger.getConditions();
        return this.valid(flow, conditions, conditionContext);
    }

    public boolean isValid(List<ScheduleCondition> conditions, ConditionContext conditionContext) throws InternalException {
        return conditions.stream().allMatch(Rethrow.throwPredicate(condition -> condition.test(conditionContext)));
    }

    public boolean areValid(List<Condition> conditions, ConditionContext conditionContext) throws InternalException {
        return conditions.stream().allMatch(Rethrow.throwPredicate(condition -> condition.test(conditionContext)));
    }

    public boolean isValid(AbstractTrigger trigger, Flow flow, Execution execution, MultipleConditionStorageInterface multipleConditionStorage) {
        assert (execution != null);
        ArrayList<Condition> conditions = trigger.getConditions() == null ? new ArrayList() : trigger.getConditions();
        ConditionContext conditionContext = this.conditionContext(this.runContextFactory.of((FlowInterface)flow, execution), flow, execution, multipleConditionStorage);
        return this.valid(flow, conditions, conditionContext);
    }

    public boolean isValid(MultipleCondition preconditions, Flow flow, Execution execution, MultipleConditionStorageInterface multipleConditionStorage) {
        ConditionContext conditionContext = this.conditionContext(this.runContextFactory.of((FlowInterface)flow, execution), flow, execution, multipleConditionStorage);
        try {
            return preconditions == null || preconditions.getConditions() == null || preconditions.test(conditionContext);
        }
        catch (Exception e) {
            this.logException(flow, preconditions, conditionContext, e);
            return false;
        }
    }

    public ConditionContext conditionContext(RunContext runContext, FlowInterface flow, @Nullable Execution execution, MultipleConditionStorageInterface multipleConditionStorage) {
        return ConditionContext.builder().flow(flow).execution(execution).runContext(runContext).multipleConditionStorage(multipleConditionStorage).build();
    }

    public ConditionContext conditionContext(RunContext runContext, Flow flow, @Nullable Execution execution) {
        return this.conditionContext(runContext, flow, execution, null);
    }

    public boolean valid(FlowInterface flow, List<Condition> list, ConditionContext conditionContext) {
        return list.stream().allMatch(condition -> {
            try {
                return condition.test(conditionContext);
            }
            catch (Exception e) {
                this.logException(flow, condition, conditionContext, e);
                return false;
            }
        });
    }

    public List<ResolvedTask> findValidListeners(Flow flow, Execution execution) {
        if (flow == null || flow.getListeners() == null) {
            return Collections.emptyList();
        }
        ConditionContext conditionContext = this.conditionContext(this.runContextFactory.of((FlowInterface)flow, execution), flow, execution);
        return flow.getListeners().stream().filter(listener -> listener.getConditions() == null || this.valid(flow, listener.getConditions(), conditionContext)).flatMap(listener -> listener.getTasks().stream()).map(ResolvedTask::of).toList();
    }
}

