/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.services;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.Label;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.ListUtils;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class LabelService {
    private LabelService() {
    }

    public static List<Label> labelsExcludingSystem(FlowInterface flow) {
        return ListUtils.emptyOnNull(flow.getLabels()).stream().filter(label -> !label.key().startsWith("system.")).toList();
    }

    public static List<Label> fromTrigger(RunContext runContext, FlowInterface flow, AbstractTrigger trigger) {
        ArrayList<Label> labels = new ArrayList<Label>();
        if (flow.getLabels() != null) {
            labels.addAll(LabelService.labelsExcludingSystem(flow));
        }
        if (trigger.getLabels() != null) {
            for (Label label : trigger.getLabels()) {
                String value = LabelService.renderLabelValue(runContext, label);
                if (value == null) continue;
                labels.add(new Label(label.key(), value));
            }
        }
        return labels;
    }

    private static String renderLabelValue(RunContext runContext, Label label) {
        try {
            return runContext.render(label.value());
        }
        catch (IllegalVariableEvaluationException e) {
            runContext.logger().warn("Failed to render label '{}', it will be omitted", (Object)label.key(), (Object)e);
            return null;
        }
    }

    public static boolean containsAll(@Nullable List<Label> labelsContainer, @Nullable List<Label> labelsThatMustBeIncluded) {
        Map labelsContainerMap = ListUtils.emptyOnNull(labelsContainer).stream().collect(HashMap::new, (m, label) -> m.put(label.key(), label.value()), HashMap::putAll);
        return ListUtils.emptyOnNull(labelsThatMustBeIncluded).stream().allMatch(label -> Objects.equals(labelsContainerMap.get(label.key()), label.value()));
    }
}

