/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.storages;

import com.google.common.annotations.VisibleForTesting;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.FlowId;
import io.kestra.core.utils.Hashing;
import io.kestra.core.utils.Slugify;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public class StorageContext {
    public static final String KESTRA_SCHEME = "kestra";
    public static final String KESTRA_PROTOCOL = "kestra://";
    public static final String PREFIX_MESSAGES = "/_messages";
    static final String PREFIX_FORMAT_NAMESPACE_FILE = "/%s/_files";
    static final String PREFIX_FORMAT_KV = "/%s/_kv";
    static final String PREFIX_FORMAT_FLOWS = "/%s/%s";
    static final String PREFIX_FORMAT_EXECUTIONS = "/%s/%s/executions/%s";
    static final String PREFIX_FORMAT_TASK = "/%s/%s/executions/%s/tasks/%s/%s";
    static final String PREFIX_FORMAT_TRIGGER = "/%s/%s/executions/%s/trigger/%s";
    static final String PREFIX_FORMAT_INPUTS = "/%s/%s/executions/%s/inputs/%s/%s";
    static final String PREFIX_FORMAT_CACHE_OBJECT = "/%s/%s/%s/cache/%s/cache.zip";
    static final String PREFIX_FORMAT_CACHE = "/%s/%s/%s/cache/cache.zip";
    private final String tenantId;
    private final String namespace;
    private final String flowId;
    private final String executionId;

    public static StorageContext forTask(TaskRun taskRun) {
        return new Task(taskRun.getTenantId(), taskRun.getNamespace(), taskRun.getFlowId(), taskRun.getExecutionId(), taskRun.getTaskId(), taskRun.getId(), taskRun.getValue());
    }

    public static StorageContext forFlow(FlowId flow) {
        return new StorageContext(flow.getTenantId(), flow.getNamespace(), flow.getId());
    }

    public static StorageContext forExecution(Execution execution) {
        return StorageContext.forExecution(execution.getTenantId(), execution.getNamespace(), execution.getFlowId(), execution.getId());
    }

    public static StorageContext forExecution(@Nullable String tenantId, String namespace, String flowId, String executionId) {
        return new StorageContext(tenantId, namespace, flowId, executionId);
    }

    public static Input forInput(Execution execution, String inputName, String fileName) {
        return new Input(execution.getTenantId(), execution.getNamespace(), execution.getFlowId(), execution.getId(), inputName, fileName);
    }

    public static Task forTask(@Nullable String tenantId, String namespace, String flowId, String executionId, String taskId, String taskRunId, @Nullable String taskRunValue) {
        return new Task(tenantId, namespace, flowId, executionId, taskId, taskRunId, taskRunValue);
    }

    public static Trigger forTrigger(@Nullable String tenantId, String namespace, String flowId, String executionId, String triggerId) {
        return new Trigger(tenantId, namespace, flowId, executionId, triggerId);
    }

    @VisibleForTesting
    public StorageContext() {
        this.tenantId = null;
        this.namespace = null;
        this.flowId = null;
        this.executionId = null;
    }

    private StorageContext(@Nullable String tenantId, String namespace, String flowId) {
        this.tenantId = tenantId;
        this.namespace = Objects.requireNonNull(namespace, "namespace cannot be null");
        this.flowId = Objects.requireNonNull(flowId, "flowId cannot be null");
        this.executionId = null;
    }

    private StorageContext(@Nullable String tenantId, String namespace, String flowId, String executionId) {
        this.tenantId = tenantId;
        this.namespace = Objects.requireNonNull(namespace, "namespace cannot be null");
        this.flowId = Objects.requireNonNull(flowId, "flowId cannot be null");
        this.executionId = Objects.requireNonNull(executionId, "executionId cannot be null");
    }

    public static Optional<String> extractExecutionId(URI path) {
        Pattern pattern = Pattern.compile("^/(.+)/executions/([^/]+)/", 2);
        Matcher matcher = pattern.matcher(path.getPath());
        if (!matcher.find() || matcher.group(2).isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(matcher.group(2));
    }

    public URI getCacheURI(String cacheId, @Nullable String objectId) {
        String prefix;
        Objects.requireNonNull(cacheId, "Cannot create URI with id null");
        if (objectId == null) {
            prefix = String.format(PREFIX_FORMAT_CACHE, this.getNamespaceAsPath(), Slugify.of(this.getFlowId()), Slugify.of(cacheId));
        } else {
            String hashedObjectId = Hashing.hashToString(objectId);
            prefix = String.format(PREFIX_FORMAT_CACHE_OBJECT, this.getNamespaceAsPath(), Slugify.of(this.getFlowId()), Slugify.of(cacheId), hashedObjectId);
        }
        return URI.create(prefix);
    }

    public String getNamespaceAsPath() {
        return this.getNamespace().replace(".", "/");
    }

    public String getStateStorePrefix(String id, Boolean isNamespace, String value) {
        ArrayList<String> paths = new ArrayList<String>(List.of(this.getNamespaceAsPath()));
        if (!isNamespace.booleanValue()) {
            paths.add(Slugify.of(this.getFlowId()));
        }
        paths.add("states");
        if (id != null) {
            paths.add(id);
        }
        if (value != null) {
            paths.add(Hashing.hashToString(value));
        }
        return "/" + String.join((CharSequence)"/", paths);
    }

    public URI getFlowStorageURI() {
        try {
            String prefix = String.format(PREFIX_FORMAT_FLOWS, this.getNamespaceAsPath(), Slugify.of(this.getFlowId()));
            return new URI("//" + prefix);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public URI getExecutionStorageURI() {
        return this.getExecutionStorageURI(null);
    }

    public URI getExecutionStorageURI(@Nullable String scheme) {
        try {
            String schemePrefix = Optional.ofNullable(scheme).map(s -> s.endsWith("://") ? s : s + "://").orElse("//");
            String prefix = String.format(PREFIX_FORMAT_EXECUTIONS, this.getNamespaceAsPath(), Slugify.of(this.flowId), this.executionId);
            return new URI(schemePrefix + prefix);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public URI getContextStorageURI() {
        return this.getExecutionStorageURI();
    }

    public String toString() {
        return "StorageContext::Execution";
    }

    public static String namespaceFilePrefix(String namespace) {
        return String.format(PREFIX_FORMAT_NAMESPACE_FILE, namespace.replace(".", "/"));
    }

    public static String kvPrefix(String namespace) {
        return String.format(PREFIX_FORMAT_KV, namespace.replace(".", "/"));
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getFlowId() {
        return this.flowId;
    }

    @Generated
    public String getExecutionId() {
        return this.executionId;
    }

    public static class Task
    extends StorageContext {
        private final String taskId;
        private final String taskRunId;
        private final String taskRunValue;

        private Task(String tenantId, String namespace, String flowId, String executionId, String taskId, String taskRunId, @Nullable String taskRunValue) {
            super(tenantId, namespace, flowId, executionId);
            this.taskId = Objects.requireNonNull(taskId, "taskID cannot be null");
            this.taskRunId = Objects.requireNonNull(taskRunId, "taskRunID cannot be null");
            this.taskRunValue = taskRunValue;
        }

        @Override
        public URI getContextStorageURI() {
            try {
                String prefix = String.format(StorageContext.PREFIX_FORMAT_TASK, this.getNamespaceAsPath(), Slugify.of(this.getFlowId()), this.getExecutionId(), Slugify.of(this.getTaskId()), this.getTaskRunId());
                return new URI("//" + prefix);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public String toString() {
            return "StorageContext::Task";
        }

        @Generated
        public String getTaskId() {
            return this.taskId;
        }

        @Generated
        public String getTaskRunId() {
            return this.taskRunId;
        }

        @Generated
        public String getTaskRunValue() {
            return this.taskRunValue;
        }
    }

    public static class Input
    extends StorageContext {
        private final String inputName;
        private final String fileName;

        private Input(String tenantId, String namespace, String flowId, String executionId, String inputName, String fileName) {
            super(tenantId, namespace, flowId, executionId);
            this.inputName = Objects.requireNonNull(inputName, "inputName cannot be null");
            this.fileName = Objects.requireNonNull(fileName, "fileName cannot be null");
        }

        @Override
        public URI getContextStorageURI() {
            try {
                String prefix = String.format(StorageContext.PREFIX_FORMAT_INPUTS, this.getNamespaceAsPath(), Slugify.of(this.getFlowId()), this.getExecutionId(), this.inputName, this.fileName);
                return new URI("//" + prefix);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public String toString() {
            return "StorageContext::Input";
        }

        @Generated
        public String getInputName() {
            return this.inputName;
        }

        @Generated
        public String getFileName() {
            return this.fileName;
        }
    }

    public static class Trigger
    extends StorageContext {
        private final String triggerId;

        private Trigger(String tenantId, String namespace, String flowId, String executionId, String triggerId) {
            super(tenantId, namespace, flowId, executionId);
            this.triggerId = Objects.requireNonNull(triggerId, "triggerId cannot be null");
        }

        @Override
        public URI getContextStorageURI() {
            try {
                String prefix = String.format(StorageContext.PREFIX_FORMAT_TRIGGER, this.getNamespaceAsPath(), Slugify.of(this.getFlowId()), this.getExecutionId(), Slugify.of(this.getTriggerId()));
                return new URI("//" + prefix);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public String toString() {
            return "StorageContext::Trigger";
        }

        @Generated
        public String getTriggerId() {
            return this.triggerId;
        }
    }
}

