/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.storages.kv;

import io.kestra.core.exceptions.ResourceExpiredException;
import io.kestra.core.models.FetchVersion;
import io.kestra.core.models.QueryFilter;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.storages.StorageContext;
import io.kestra.core.storages.kv.KVEntry;
import io.kestra.core.storages.kv.KVMetadata;
import io.kestra.core.storages.kv.KVValue;
import io.kestra.core.storages.kv.KVValueAndMetadata;
import io.micronaut.data.model.Pageable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;

public interface KVStore {
    public static final Pattern KEY_VALIDATOR_PATTERN = Pattern.compile("[a-zA-Z0-9][a-zA-Z0-9._-]*");

    public String namespace();

    default public URI storageUri(String key) {
        return this.storageUri(key, 1);
    }

    default public URI storageUri(String key, int version) {
        return this.storageUri(key, this.namespace(), version);
    }

    default public URI storageUri(String key, String namespace, int version) {
        String filePath = key == null ? "" : "/" + key + ".ion" + (String)(version > 1 ? ".v" + version : "");
        return URI.create("kestra://" + StorageContext.kvPrefix(namespace) + filePath);
    }

    default public void put(String key, KVValueAndMetadata value) throws IOException {
        this.put(key, value, true);
    }

    public void put(String var1, KVValueAndMetadata var2, boolean var3) throws IOException;

    public Optional<KVValue> getValue(String var1) throws IOException, ResourceExpiredException;

    public boolean delete(String var1) throws IOException;

    public Integer purge(List<KVEntry> var1) throws IOException;

    default public ArrayListTotal<KVEntry> list() throws IOException {
        return this.list(Pageable.UNPAGED);
    }

    default public ArrayListTotal<KVEntry> list(Pageable pageable) throws IOException {
        return this.list(pageable, Collections.emptyList());
    }

    default public ArrayListTotal<KVEntry> list(Pageable pageable, List<QueryFilter> queryFilters) throws IOException {
        return this.list(pageable, queryFilters, false, false, FetchVersion.LATEST);
    }

    public ArrayListTotal<KVEntry> list(Pageable var1, List<QueryFilter> var2, boolean var3, boolean var4, FetchVersion var5) throws IOException;

    public List<KVEntry> listAll() throws IOException;

    public Optional<KVEntry> get(String var1) throws IOException;

    default public boolean exists(String key) throws IOException {
        return this.get(key).isPresent();
    }

    default public Optional<KVValueAndMetadata> findMetadataAndValue(String key) throws UncheckedIOException {
        try {
            return this.get(key).flatMap(entry -> {
                try {
                    return this.getValue(entry.key()).map(current -> new KVValueAndMetadata(new KVMetadata(entry.description(), entry.expirationDate()), current.value()));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                catch (ResourceExpiredException e) {
                    return Optional.empty();
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void validateKey(String key) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Key cannot be null or empty");
        }
        if (!KEY_VALIDATOR_PATTERN.matcher(key).matches()) {
            throw new IllegalArgumentException("Key must start with an alphanumeric character (uppercase or lowercase) and can contain alphanumeric characters (uppercase or lowercase), dots (.), underscores (_), and hyphens (-) only.");
        }
    }
}

